// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_STRING_UNSIGNEDLONG_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_STRING_UNSIGNEDLONG_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class ScriptState;

class CORE_EXPORT V8UnionStringOrUnsignedLong final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kString, kUnsignedLong
};

static V8UnionStringOrUnsignedLong* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionStringOrUnsignedLong(const String& value);
explicit  V8UnionStringOrUnsignedLong(String&& value);
explicit  V8UnionStringOrUnsignedLong(uint32_t value) : content_type_(ContentType::kUnsignedLong), member_unsigned_long_(value) {
  
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsString() const {
  return content_type_ == ContentType::kString;
}
const String& GetAsString() const {
  DCHECK_EQ(content_type_, ContentType::kString);
return member_string_;
}
void Set(const String& value);
void Set(String&& value);

bool IsUnsignedLong() const {
  return content_type_ == ContentType::kUnsignedLong;
}
uint32_t GetAsUnsignedLong() const {
  DCHECK_EQ(content_type_, ContentType::kUnsignedLong);
return member_unsigned_long_;
}
void Set(uint32_t value) {
  Clear();
member_unsigned_long_ = value;
content_type_ = ContentType::kUnsignedLong;
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(DOMString or unsigned long)";
}

ContentType content_type_;

String member_string_;
uint32_t member_unsigned_long_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_STRING_UNSIGNEDLONG_H_
