// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_STRING_STRINGSEQUENCE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_STRING_STRINGSEQUENCE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class ScriptState;

class CORE_EXPORT V8UnionStringOrStringSequence final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kString, kStringSequence
};

static V8UnionStringOrStringSequence* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionStringOrStringSequence(const String& value);
explicit  V8UnionStringOrStringSequence(String&& value);
explicit  V8UnionStringOrStringSequence(const Vector<String>& value);
explicit  V8UnionStringOrStringSequence(Vector<String>&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsString() const {
  return content_type_ == ContentType::kString;
}
const String& GetAsString() const {
  DCHECK_EQ(content_type_, ContentType::kString);
return member_string_;
}
void Set(const String& value);
void Set(String&& value);

bool IsStringSequence() const {
  return content_type_ == ContentType::kStringSequence;
}
const Vector<String>& GetAsStringSequence() const {
  DCHECK_EQ(content_type_, ContentType::kStringSequence);
return member_string_sequence_;
}
void Set(const Vector<String>& value);
void Set(Vector<String>&& value);


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(DOMString or sequence<DOMString>)";
}

ContentType content_type_;

String member_string_;
Vector<String> member_string_sequence_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_STRING_STRINGSEQUENCE_H_
