// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_RESPONSE_UNDEFINED_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_RESPONSE_UNDEFINED_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class Response;
class ScriptState;

class CORE_EXPORT V8UnionResponseOrUndefined final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kResponse, kUndefined
};

static V8UnionResponseOrUndefined* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionResponseOrUndefined(Response* value) : content_type_(ContentType::kResponse), member_response_(value) {
  DCHECK(value);
}
explicit  V8UnionResponseOrUndefined(const ToV8UndefinedGenerator& value) : content_type_(ContentType::kUndefined), member_undefined_(value) {
  
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsResponse() const {
  return content_type_ == ContentType::kResponse;
}
Response* GetAsResponse() const {
  DCHECK_EQ(content_type_, ContentType::kResponse);
return member_response_.Get();
}
void Set(Response* value) {
  DCHECK(value);
Clear();
member_response_ = value;
content_type_ = ContentType::kResponse;
}

bool IsUndefined() const {
  return content_type_ == ContentType::kUndefined;
}
const ToV8UndefinedGenerator& GetAsUndefined() const {
  DCHECK_EQ(content_type_, ContentType::kUndefined);
return member_undefined_;
}
void Set(const ToV8UndefinedGenerator& value) {
  Clear();
member_undefined_ = value;
content_type_ = ContentType::kUndefined;
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(Response or undefined)";
}

ContentType content_type_;

Member<Response> member_response_;
ToV8UndefinedGenerator member_undefined_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_RESPONSE_UNDEFINED_H_
