// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_observableinspector_observercallback.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_observable_inspector.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_observer_callback.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionObservableInspectorOrObserverCallback* V8UnionObservableInspectorOrObserverCallback::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsNullOrUndefined()) {
  auto&& blink_value = ObservableInspector::Create(isolate);
return MakeGarbageCollected<V8UnionObservableInspectorOrObserverCallback>(blink_value);
}
if (v8_value->IsFunction()) {
  auto&& blink_value = V8ObserverCallback::Create(v8_value.As<v8::Function>());
return MakeGarbageCollected<V8UnionObservableInspectorOrObserverCallback>(blink_value);
}
if (v8_value->IsObject()) {
  auto&& blink_value = NativeValueTraits<ObservableInspector>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionObservableInspectorOrObserverCallback>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}










void V8UnionObservableInspectorOrObserverCallback::Trace(Visitor* visitor) const {
  visitor->Trace(member_observable_inspector_);
visitor->Trace(member_observer_callback_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionObservableInspectorOrObserverCallback::Clear() {
  member_observable_inspector_.Clear();
member_observer_callback_.Clear();
}



}  // namespace blink
