// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_object_objectarray_string.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_object_string.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionObjectOrObjectArrayOrString* V8UnionObjectOrObjectArrayOrString::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsArray()) {
  auto&& blink_value = NativeValueTraits<IDLArray<IDLObject>>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionObjectOrObjectArrayOrString>(std::move(blink_value));
}
if (v8_value->IsObject()) {
  ScriptIterator script_iterator = ScriptIterator::FromIterable(isolate, v8_value.As<v8::Object>(), exception_state, ScriptIterator::Kind::kSync);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
if (!script_iterator.IsNull()) {
  auto&& blink_value = bindings::CreateIDLSequenceFromIterator<IDLObject>(isolate, std::move(script_iterator), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionObjectOrObjectArrayOrString>(std::move(blink_value));
}
}
if (v8_value->IsObject()) {
  auto&& blink_value = ScriptObject(isolate, v8_value);
return MakeGarbageCollected<V8UnionObjectOrObjectArrayOrString>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionObjectOrObjectArrayOrString>(std::move(blink_value));
}
}

 V8UnionObjectOrObjectArrayOrString::V8UnionObjectOrObjectArrayOrString(const HeapVector<ScriptObject>& value) : content_type_(ContentType::kObjectArray), member_object_array_(value) {
  
}

 V8UnionObjectOrObjectArrayOrString::V8UnionObjectOrObjectArrayOrString(HeapVector<ScriptObject>&& value) : content_type_(ContentType::kObjectArray), member_object_array_(std::move(value)) {
  
}

 V8UnionObjectOrObjectArrayOrString::V8UnionObjectOrObjectArrayOrString(const String& value) : content_type_(ContentType::kString), member_string_(value) {
  
}

 V8UnionObjectOrObjectArrayOrString::V8UnionObjectOrObjectArrayOrString(String&& value) : content_type_(ContentType::kString), member_string_(std::move(value)) {
  
}







void V8UnionObjectOrObjectArrayOrString::Set(const HeapVector<ScriptObject>& value) {
  Clear();
member_object_array_ = value;
content_type_ = ContentType::kObjectArray;
}

void V8UnionObjectOrObjectArrayOrString::Set(HeapVector<ScriptObject>&& value) {
  Clear();
member_object_array_ = std::move(value);
content_type_ = ContentType::kObjectArray;
}



void V8UnionObjectOrObjectArrayOrString::Set(const String& value) {
  Clear();
member_string_ = value;
content_type_ = ContentType::kString;
}

void V8UnionObjectOrObjectArrayOrString::Set(String&& value) {
  Clear();
member_string_ = std::move(value);
content_type_ = ContentType::kString;
}


V8UnionObjectOrString* V8UnionObjectOrObjectArrayOrString::GetAsV8UnionObjectOrString() const {
  switch (content_type_) {
  case ContentType::kObject: {
    return MakeGarbageCollected<V8UnionObjectOrString>(GetAsObject());
  }
  case ContentType::kString: {
    return MakeGarbageCollected<V8UnionObjectOrString>(GetAsString());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionObjectOrObjectArrayOrString::Set(const V8UnionObjectOrString* value) {
  switch (value->GetContentType()) {
  case V8UnionObjectOrString::ContentType::kObject: {
    Set(value->GetAsObject());
    break;
  }
  case V8UnionObjectOrString::ContentType::kString: {
    Set(value->GetAsString());
    break;
  }
}
}




void V8UnionObjectOrObjectArrayOrString::Trace(Visitor* visitor) const {
  visitor->Trace(member_object_);
visitor->Trace(member_object_array_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionObjectOrObjectArrayOrString::Clear() {
  member_object_.Clear();
member_object_array_.clear();
member_string_ = String();
}



}  // namespace blink
