// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_NODE_STRING_TRUSTEDSCRIPT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_NODE_STRING_TRUSTEDSCRIPT_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class Node;
class ScriptState;
class TrustedScript;
class V8UnionNodeOrString;
class V8UnionStringOrTrustedScript;

class CORE_EXPORT V8UnionNodeOrStringOrTrustedScript final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kNode, kString, kTrustedScript
};

static V8UnionNodeOrStringOrTrustedScript* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionNodeOrStringOrTrustedScript(Node* value) : content_type_(ContentType::kNode), member_node_(value) {
  DCHECK(value);
}
explicit  V8UnionNodeOrStringOrTrustedScript(const String& value);
explicit  V8UnionNodeOrStringOrTrustedScript(String&& value);
explicit  V8UnionNodeOrStringOrTrustedScript(TrustedScript* value) : content_type_(ContentType::kTrustedScript), member_trusted_script_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsNode() const {
  return content_type_ == ContentType::kNode;
}
Node* GetAsNode() const {
  DCHECK_EQ(content_type_, ContentType::kNode);
return member_node_.Get();
}
void Set(Node* value) {
  DCHECK(value);
Clear();
member_node_ = value;
content_type_ = ContentType::kNode;
}

bool IsString() const {
  return content_type_ == ContentType::kString;
}
const String& GetAsString() const {
  DCHECK_EQ(content_type_, ContentType::kString);
return member_string_;
}
void Set(const String& value);
void Set(String&& value);

bool IsTrustedScript() const {
  return content_type_ == ContentType::kTrustedScript;
}
TrustedScript* GetAsTrustedScript() const {
  DCHECK_EQ(content_type_, ContentType::kTrustedScript);
return member_trusted_script_.Get();
}
void Set(TrustedScript* value) {
  DCHECK(value);
Clear();
member_trusted_script_ = value;
content_type_ = ContentType::kTrustedScript;
}

bool IsV8UnionNodeOrString() const {
  return content_type_ == ContentType::kNode || content_type_ == ContentType::kString;
}
V8UnionNodeOrString* GetAsV8UnionNodeOrString() const;
void Set(const V8UnionNodeOrString* value);

bool IsV8UnionStringOrTrustedScript() const {
  return content_type_ == ContentType::kString || content_type_ == ContentType::kTrustedScript;
}
V8UnionStringOrTrustedScript* GetAsV8UnionStringOrTrustedScript() const;
void Set(const V8UnionStringOrTrustedScript* value);


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(DOMString or Node or TrustedScript)";
}

ContentType content_type_;

Member<Node> member_node_;
String member_string_;
Member<TrustedScript> member_trusted_script_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_NODE_STRING_TRUSTEDSCRIPT_H_
