// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_node_string_trustedscript.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_node.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_trusted_script.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_node_string.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_string_trustedscript.h"
#include "third_party/blink/renderer/core/dom/node.h"
#include "third_party/blink/renderer/core/trustedtypes/trusted_script.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionNodeOrStringOrTrustedScript* V8UnionNodeOrStringOrTrustedScript::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8Node::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8Node::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionNodeOrStringOrTrustedScript>(blink_value);
}
if (V8TrustedScript::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8TrustedScript::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionNodeOrStringOrTrustedScript>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionNodeOrStringOrTrustedScript>(std::move(blink_value));
}
}

 V8UnionNodeOrStringOrTrustedScript::V8UnionNodeOrStringOrTrustedScript(const String& value) : content_type_(ContentType::kString), member_string_(value) {
  
}

 V8UnionNodeOrStringOrTrustedScript::V8UnionNodeOrStringOrTrustedScript(String&& value) : content_type_(ContentType::kString), member_string_(std::move(value)) {
  
}







void V8UnionNodeOrStringOrTrustedScript::Set(const String& value) {
  Clear();
member_string_ = value;
content_type_ = ContentType::kString;
}

void V8UnionNodeOrStringOrTrustedScript::Set(String&& value) {
  Clear();
member_string_ = std::move(value);
content_type_ = ContentType::kString;
}





V8UnionNodeOrString* V8UnionNodeOrStringOrTrustedScript::GetAsV8UnionNodeOrString() const {
  switch (content_type_) {
  case ContentType::kNode: {
    return MakeGarbageCollected<V8UnionNodeOrString>(GetAsNode());
  }
  case ContentType::kString: {
    return MakeGarbageCollected<V8UnionNodeOrString>(GetAsString());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionNodeOrStringOrTrustedScript::Set(const V8UnionNodeOrString* value) {
  switch (value->GetContentType()) {
  case V8UnionNodeOrString::ContentType::kNode: {
    Set(value->GetAsNode());
    break;
  }
  case V8UnionNodeOrString::ContentType::kString: {
    Set(value->GetAsString());
    break;
  }
}
}


V8UnionStringOrTrustedScript* V8UnionNodeOrStringOrTrustedScript::GetAsV8UnionStringOrTrustedScript() const {
  switch (content_type_) {
  case ContentType::kString: {
    return MakeGarbageCollected<V8UnionStringOrTrustedScript>(GetAsString());
  }
  case ContentType::kTrustedScript: {
    return MakeGarbageCollected<V8UnionStringOrTrustedScript>(GetAsTrustedScript());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionNodeOrStringOrTrustedScript::Set(const V8UnionStringOrTrustedScript* value) {
  switch (value->GetContentType()) {
  case V8UnionStringOrTrustedScript::ContentType::kString: {
    Set(value->GetAsString());
    break;
  }
  case V8UnionStringOrTrustedScript::ContentType::kTrustedScript: {
    Set(value->GetAsTrustedScript());
    break;
  }
}
}


void V8UnionNodeOrStringOrTrustedScript::Trace(Visitor* visitor) const {
  visitor->Trace(member_node_);
visitor->Trace(member_trusted_script_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionNodeOrStringOrTrustedScript::Clear() {
  member_node_.Clear();
member_string_ = String();
member_trusted_script_.Clear();
}



}  // namespace blink
