// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_float_stringelementrecord.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/core/dom/element.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionFloatOrStringElementRecord* V8UnionFloatOrStringElementRecord::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsObject()) {
  auto&& blink_value = NativeValueTraits<IDLRecord<IDLString, Element>>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionFloatOrStringElementRecord>(std::move(blink_value));
}
if (v8_value->IsNumber()) {
  auto&& blink_value = NativeValueTraits<IDLFloat>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionFloatOrStringElementRecord>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLFloat>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionFloatOrStringElementRecord>(blink_value);
}
}

 V8UnionFloatOrStringElementRecord::V8UnionFloatOrStringElementRecord(const HeapVector<std::pair<String, Member<Element>>>& value) : content_type_(ContentType::kStringElementRecord), member_string_element_record_(value) {
  
}

 V8UnionFloatOrStringElementRecord::V8UnionFloatOrStringElementRecord(HeapVector<std::pair<String, Member<Element>>>&& value) : content_type_(ContentType::kStringElementRecord), member_string_element_record_(std::move(value)) {
  
}







void V8UnionFloatOrStringElementRecord::Set(const HeapVector<std::pair<String, Member<Element>>>& value) {
  Clear();
member_string_element_record_ = value;
content_type_ = ContentType::kStringElementRecord;
}

void V8UnionFloatOrStringElementRecord::Set(HeapVector<std::pair<String, Member<Element>>>&& value) {
  Clear();
member_string_element_record_ = std::move(value);
content_type_ = ContentType::kStringElementRecord;
}


void V8UnionFloatOrStringElementRecord::Trace(Visitor* visitor) const {
  visitor->Trace(member_string_element_record_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionFloatOrStringElementRecord::Clear() {
  member_float_ = 0;
member_string_element_record_.clear();
}



}  // namespace blink
