// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_DOUBLE_DOUBLESEQUENCE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_DOUBLE_DOUBLESEQUENCE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"

namespace blink {

class ExceptionState;
class ScriptState;

class CORE_EXPORT V8UnionDoubleOrDoubleSequence final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kDouble, kDoubleSequence
};

static V8UnionDoubleOrDoubleSequence* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionDoubleOrDoubleSequence(double value) : content_type_(ContentType::kDouble), member_double_(value) {
  
}
explicit  V8UnionDoubleOrDoubleSequence(const Vector<double>& value);
explicit  V8UnionDoubleOrDoubleSequence(Vector<double>&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsDouble() const {
  return content_type_ == ContentType::kDouble;
}
double GetAsDouble() const {
  DCHECK_EQ(content_type_, ContentType::kDouble);
return member_double_;
}
void Set(double value) {
  Clear();
member_double_ = value;
content_type_ = ContentType::kDouble;
}

bool IsDoubleSequence() const {
  return content_type_ == ContentType::kDoubleSequence;
}
const Vector<double>& GetAsDoubleSequence() const {
  DCHECK_EQ(content_type_, ContentType::kDoubleSequence);
return member_double_sequence_;
}
void Set(const Vector<double>& value);
void Set(Vector<double>&& value);


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(double or sequence<double>)";
}

ContentType content_type_;

double member_double_;
Vector<double> member_double_sequence_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_DOUBLE_DOUBLESEQUENCE_H_
