// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_DOCUMENTTIMELINE_SCROLLTIMELINE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_DOCUMENTTIMELINE_SCROLLTIMELINE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class DocumentTimeline;
class ExceptionState;
class ScriptState;
class ScrollTimeline;

class CORE_EXPORT V8UnionDocumentTimelineOrScrollTimeline final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kDocumentTimeline, kScrollTimeline
};

static V8UnionDocumentTimelineOrScrollTimeline* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionDocumentTimelineOrScrollTimeline(DocumentTimeline* value) : content_type_(ContentType::kDocumentTimeline), member_document_timeline_(value) {
  DCHECK(value);
}
explicit  V8UnionDocumentTimelineOrScrollTimeline(ScrollTimeline* value) : content_type_(ContentType::kScrollTimeline), member_scroll_timeline_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsDocumentTimeline() const {
  return content_type_ == ContentType::kDocumentTimeline;
}
DocumentTimeline* GetAsDocumentTimeline() const {
  DCHECK_EQ(content_type_, ContentType::kDocumentTimeline);
return member_document_timeline_.Get();
}
void Set(DocumentTimeline* value) {
  DCHECK(value);
Clear();
member_document_timeline_ = value;
content_type_ = ContentType::kDocumentTimeline;
}

bool IsScrollTimeline() const {
  return content_type_ == ContentType::kScrollTimeline;
}
ScrollTimeline* GetAsScrollTimeline() const {
  DCHECK_EQ(content_type_, ContentType::kScrollTimeline);
return member_scroll_timeline_.Get();
}
void Set(ScrollTimeline* value) {
  DCHECK(value);
Clear();
member_scroll_timeline_ = value;
content_type_ = ContentType::kScrollTimeline;
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(DocumentTimeline or ScrollTimeline)";
}

ContentType content_type_;

Member<DocumentTimeline> member_document_timeline_;
Member<ScrollTimeline> member_scroll_timeline_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_DOCUMENTTIMELINE_SCROLLTIMELINE_H_
