// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_CSSKEYWORDVALUE_CSSNUMERICVALUE_STRING_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_CSSKEYWORDVALUE_CSSNUMERICVALUE_STRING_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class CSSKeywordValue;
class CSSNumericValue;
class ExceptionState;
class ScriptState;
class V8UnionCSSKeywordValueOrString;
class V8UnionCSSNumericValueOrString;

class CORE_EXPORT V8UnionCSSKeywordValueOrCSSNumericValueOrString final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kCSSKeywordValue, kCSSNumericValue, kString
};

static V8UnionCSSKeywordValueOrCSSNumericValueOrString* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionCSSKeywordValueOrCSSNumericValueOrString(CSSKeywordValue* value) : content_type_(ContentType::kCSSKeywordValue), member_css_keyword_value_(value) {
  DCHECK(value);
}
explicit  V8UnionCSSKeywordValueOrCSSNumericValueOrString(CSSNumericValue* value) : content_type_(ContentType::kCSSNumericValue), member_css_numeric_value_(value) {
  DCHECK(value);
}
explicit  V8UnionCSSKeywordValueOrCSSNumericValueOrString(const String& value);
explicit  V8UnionCSSKeywordValueOrCSSNumericValueOrString(String&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsCSSKeywordValue() const {
  return content_type_ == ContentType::kCSSKeywordValue;
}
CSSKeywordValue* GetAsCSSKeywordValue() const {
  DCHECK_EQ(content_type_, ContentType::kCSSKeywordValue);
return member_css_keyword_value_.Get();
}
void Set(CSSKeywordValue* value) {
  DCHECK(value);
Clear();
member_css_keyword_value_ = value;
content_type_ = ContentType::kCSSKeywordValue;
}

bool IsCSSNumericValue() const {
  return content_type_ == ContentType::kCSSNumericValue;
}
CSSNumericValue* GetAsCSSNumericValue() const {
  DCHECK_EQ(content_type_, ContentType::kCSSNumericValue);
return member_css_numeric_value_.Get();
}
void Set(CSSNumericValue* value) {
  DCHECK(value);
Clear();
member_css_numeric_value_ = value;
content_type_ = ContentType::kCSSNumericValue;
}

bool IsString() const {
  return content_type_ == ContentType::kString;
}
const String& GetAsString() const {
  DCHECK_EQ(content_type_, ContentType::kString);
return member_string_;
}
void Set(const String& value);
void Set(String&& value);

bool IsV8UnionCSSKeywordValueOrString() const {
  return content_type_ == ContentType::kCSSKeywordValue || content_type_ == ContentType::kString;
}
V8UnionCSSKeywordValueOrString* GetAsV8UnionCSSKeywordValueOrString() const;
void Set(const V8UnionCSSKeywordValueOrString* value);
bool IsV8CSSKeywordish() const {
  return IsV8UnionCSSKeywordValueOrString();
}
V8UnionCSSKeywordValueOrString* GetAsV8CSSKeywordish() const {
  return GetAsV8UnionCSSKeywordValueOrString();
}

bool IsV8UnionCSSNumericValueOrString() const {
  return content_type_ == ContentType::kCSSNumericValue || content_type_ == ContentType::kString;
}
V8UnionCSSNumericValueOrString* GetAsV8UnionCSSNumericValueOrString() const;
void Set(const V8UnionCSSNumericValueOrString* value);


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(CSSKeywordValue or CSSNumericValue or DOMString)";
}

ContentType content_type_;

Member<CSSKeywordValue> member_css_keyword_value_;
Member<CSSNumericValue> member_css_numeric_value_;
String member_string_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_CSSKEYWORDVALUE_CSSNUMERICVALUE_STRING_H_
