// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_csscolorvalue_cssstylevalue.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_color_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_style_value.h"
#include "third_party/blink/renderer/core/css/cssom/css_color_value.h"
#include "third_party/blink/renderer/core/css/cssom/css_style_value.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionCSSColorValueOrCSSStyleValue* V8UnionCSSColorValueOrCSSStyleValue::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8CSSStyleValue::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8CSSStyleValue::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionCSSColorValueOrCSSStyleValue>(blink_value);
}
if (V8CSSColorValue::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8CSSColorValue::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionCSSColorValueOrCSSStyleValue>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}










v8::Local<v8::Value> V8UnionCSSColorValueOrCSSStyleValue::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kCSSColorValue: {
    return ToV8Traits<CSSColorValue>::ToV8(script_state, member_css_color_value_.Get());
  }
  case ContentType::kCSSStyleValue: {
    return ToV8Traits<CSSStyleValue>::ToV8(script_state, member_css_style_value_.Get());
  }
}

NOTREACHED();
}

void V8UnionCSSColorValueOrCSSStyleValue::Trace(Visitor* visitor) const {
  visitor->Trace(member_css_color_value_);
visitor->Trace(member_css_style_value_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionCSSColorValueOrCSSStyleValue::Clear() {
  member_css_color_value_.Clear();
member_css_style_value_.Clear();
}



}  // namespace blink
