// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_string.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionArrayBufferOrString* V8UnionArrayBufferOrString::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsArrayBuffer() || v8_value->IsSharedArrayBuffer()) {
  auto&& blink_value = NativeValueTraits<DOMArrayBuffer>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionArrayBufferOrString>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionArrayBufferOrString>(std::move(blink_value));
}
}

 V8UnionArrayBufferOrString::V8UnionArrayBufferOrString(const String& value) : content_type_(ContentType::kString), member_string_(value) {
  
}

 V8UnionArrayBufferOrString::V8UnionArrayBufferOrString(String&& value) : content_type_(ContentType::kString), member_string_(std::move(value)) {
  
}







void V8UnionArrayBufferOrString::Set(const String& value) {
  Clear();
member_string_ = value;
content_type_ = ContentType::kString;
}

void V8UnionArrayBufferOrString::Set(String&& value) {
  Clear();
member_string_ = std::move(value);
content_type_ = ContentType::kString;
}


v8::Local<v8::Value> V8UnionArrayBufferOrString::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kArrayBuffer: {
    return ToV8Traits<DOMArrayBuffer>::ToV8(script_state, member_array_buffer_.Get());
  }
  case ContentType::kString: {
    return ToV8Traits<IDLString>::ToV8(script_state, member_string_);
  }
}

NOTREACHED();
}

void V8UnionArrayBufferOrString::Trace(Visitor* visitor) const {
  visitor->Trace(member_array_buffer_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionArrayBufferOrString::Clear() {
  member_array_buffer_.Clear();
member_string_ = String();
}



}  // namespace blink
