// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview_blob_usvstring.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_blob.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview_usvstring.h"
#include "third_party/blink/renderer/core/fileapi/blob.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString* V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8Blob::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8Blob::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString>(blink_value);
}
if (v8_value->IsArrayBuffer() || v8_value->IsSharedArrayBuffer()) {
  auto&& blink_value = NativeValueTraits<DOMArrayBuffer>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString>(blink_value);
}
if (v8_value->IsArrayBufferView()) {
  auto&& blink_value = NativeValueTraits<NotShared<DOMArrayBufferView>>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLUSVString>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString>(std::move(blink_value));
}
}

 V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString::V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString(const String& value) : content_type_(ContentType::kUSVString), member_usv_string_(value) {
  
}

 V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString::V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString(String&& value) : content_type_(ContentType::kUSVString), member_usv_string_(std::move(value)) {
  
}













void V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString::Set(const String& value) {
  Clear();
member_usv_string_ = value;
content_type_ = ContentType::kUSVString;
}

void V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString::Set(String&& value) {
  Clear();
member_usv_string_ = std::move(value);
content_type_ = ContentType::kUSVString;
}


V8UnionArrayBufferOrArrayBufferView* V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString::GetAsV8UnionArrayBufferOrArrayBufferView() const {
  switch (content_type_) {
  case ContentType::kArrayBuffer: {
    return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferView>(GetAsArrayBuffer());
  }
  case ContentType::kArrayBufferView: {
    return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferView>(GetAsArrayBufferView());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString::Set(const V8UnionArrayBufferOrArrayBufferView* value) {
  switch (value->GetContentType()) {
  case V8UnionArrayBufferOrArrayBufferView::ContentType::kArrayBuffer: {
    Set(value->GetAsArrayBuffer());
    break;
  }
  case V8UnionArrayBufferOrArrayBufferView::ContentType::kArrayBufferView: {
    Set(value->GetAsArrayBufferView());
    break;
  }
}
}






V8UnionArrayBufferOrArrayBufferViewOrUSVString* V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString::GetAsV8UnionArrayBufferOrArrayBufferViewOrUSVString() const {
  switch (content_type_) {
  case ContentType::kArrayBuffer: {
    return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrUSVString>(GetAsArrayBuffer());
  }
  case ContentType::kArrayBufferView: {
    return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrUSVString>(GetAsArrayBufferView());
  }
  case ContentType::kUSVString: {
    return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrUSVString>(GetAsUSVString());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString::Set(const V8UnionArrayBufferOrArrayBufferViewOrUSVString* value) {
  switch (value->GetContentType()) {
  case V8UnionArrayBufferOrArrayBufferViewOrUSVString::ContentType::kArrayBuffer: {
    Set(value->GetAsArrayBuffer());
    break;
  }
  case V8UnionArrayBufferOrArrayBufferViewOrUSVString::ContentType::kArrayBufferView: {
    Set(value->GetAsArrayBufferView());
    break;
  }
  case V8UnionArrayBufferOrArrayBufferViewOrUSVString::ContentType::kUSVString: {
    Set(value->GetAsUSVString());
    break;
  }
}
}




v8::Local<v8::Value> V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kArrayBuffer: {
    return ToV8Traits<DOMArrayBuffer>::ToV8(script_state, member_array_buffer_.Get());
  }
  case ContentType::kArrayBufferView: {
    return ToV8Traits<NotShared<DOMArrayBufferView>>::ToV8(script_state, member_array_buffer_view_);
  }
  case ContentType::kBlob: {
    return ToV8Traits<Blob>::ToV8(script_state, member_blob_.Get());
  }
  case ContentType::kUSVString: {
    return ToV8Traits<IDLUSVString>::ToV8(script_state, member_usv_string_);
  }
}

NOTREACHED();
}

void V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString::Trace(Visitor* visitor) const {
  visitor->Trace(member_array_buffer_);
visitor->Trace(member_array_buffer_view_);
visitor->Trace(member_blob_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString::Clear() {
  member_array_buffer_.Clear();
member_array_buffer_view_.Clear();
member_blob_.Clear();
member_usv_string_ = String();
}



}  // namespace blink
