// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TEXT_CLUSTER_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TEXT_CLUSTER_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_canvas_text_align.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_canvas_text_baseline.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT TextClusterOptions : public bindings::InputDictionaryBase {
  
  public:
static TextClusterOptions* Create() {
  return MakeGarbageCollected<TextClusterOptions>();
}
static TextClusterOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<TextClusterOptions>(isolate);
}
static TextClusterOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  TextClusterOptions();
explicit  TextClusterOptions(v8::Isolate* isolate);

bool hasAlign() const {
  return has_align_;
}
V8CanvasTextAlign align() const {
  DCHECK(hasAlign());
return member_align_;
}
V8CanvasTextAlign getAlignOr(V8CanvasTextAlign fallback_value) const {
  if (!hasAlign()) {
  return fallback_value;
}
return member_align_;
}
void setAlign(V8CanvasTextAlign value) {
  member_align_ = value;
has_align_ = true;
}
void setAlign(V8CanvasTextAlign::Enum value) {
  member_align_ = V8CanvasTextAlign(value);
has_align_ = true;
}

bool hasBaseline() const {
  return has_baseline_;
}
V8CanvasTextBaseline baseline() const {
  DCHECK(hasBaseline());
return member_baseline_;
}
V8CanvasTextBaseline getBaselineOr(V8CanvasTextBaseline fallback_value) const {
  if (!hasBaseline()) {
  return fallback_value;
}
return member_baseline_;
}
void setBaseline(V8CanvasTextBaseline value) {
  member_baseline_ = value;
has_baseline_ = true;
}
void setBaseline(V8CanvasTextBaseline::Enum value) {
  member_baseline_ = V8CanvasTextBaseline(value);
has_baseline_ = true;
}

bool hasX() const {
  return has_x_;
}
double x() const {
  DCHECK(hasX());
return member_x_;
}
double getXOr(double fallback_value) const {
  if (!hasX()) {
  return fallback_value;
}
return member_x_;
}
void setX(double value) {
  member_x_ = value;
has_x_ = true;
}

bool hasY() const {
  return has_y_;
}
double y() const {
  DCHECK(hasY());
return member_y_;
}
double getYOr(double fallback_value) const {
  if (!hasY()) {
  return fallback_value;
}
return member_y_;
}
void setY(double value) {
  member_y_ = value;
has_y_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_align_ = false;
bool has_baseline_ = false;
bool has_x_ = false;
bool has_y_ = false;

V8CanvasTextAlign member_align_{static_cast<V8CanvasTextAlign::Enum>(0)};
V8CanvasTextBaseline member_baseline_{static_cast<V8CanvasTextBaseline::Enum>(0)};
double member_x_;
double member_y_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TEXT_CLUSTER_OPTIONS_H_
