// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_show_context_menu_item.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_accelerator.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_show_context_menu_item.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"accelerator",
"checked",
"enabled",
"featureName",
"id",
"isDevToolsPerformanceMenuItem",
"isExperimentalFeature",
"label",
"subItems",
"type",
};


}  // namespace 

ShowContextMenuItem* ShowContextMenuItem::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  ShowContextMenuItem* dictionary = MakeGarbageCollected<ShowContextMenuItem>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "ShowContextMenuItem";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 ShowContextMenuItem::ShowContextMenuItem() {
  
}

 ShowContextMenuItem::ShowContextMenuItem(v8::Isolate* isolate) {
  
}




















String ShowContextMenuItem::getFeatureNameOr(const String& fallback_value) const {
  if (!hasFeatureName()) {
  return fallback_value;
}
return member_feature_name_;
}

String ShowContextMenuItem::getFeatureNameOr(String&& fallback_value) const {
  if (!hasFeatureName()) {
  return std::move(fallback_value);
}
return member_feature_name_;
}

void ShowContextMenuItem::setFeatureName(const String& value) {
  member_feature_name_ = value;
has_feature_name_ = true;
}

void ShowContextMenuItem::setFeatureName(String&& value) {
  member_feature_name_ = std::move(value);
has_feature_name_ = true;
}





















String ShowContextMenuItem::getLabelOr(const String& fallback_value) const {
  if (!hasLabel()) {
  return fallback_value;
}
return member_label_;
}

String ShowContextMenuItem::getLabelOr(String&& fallback_value) const {
  if (!hasLabel()) {
  return std::move(fallback_value);
}
return member_label_;
}

void ShowContextMenuItem::setLabel(const String& value) {
  member_label_ = value;
has_label_ = true;
}

void ShowContextMenuItem::setLabel(String&& value) {
  member_label_ = std::move(value);
has_label_ = true;
}




HeapVector<Member<ShowContextMenuItem>> ShowContextMenuItem::getSubItemsOr(const HeapVector<Member<ShowContextMenuItem>>& fallback_value) const {
  if (!hasSubItems()) {
  return fallback_value;
}
return member_sub_items_;
}

HeapVector<Member<ShowContextMenuItem>> ShowContextMenuItem::getSubItemsOr(HeapVector<Member<ShowContextMenuItem>>&& fallback_value) const {
  if (!hasSubItems()) {
  return std::move(fallback_value);
}
return member_sub_items_;
}

void ShowContextMenuItem::setSubItems(const HeapVector<Member<ShowContextMenuItem>>& value) {
  member_sub_items_ = value;
has_sub_items_ = true;
}

void ShowContextMenuItem::setSubItems(HeapVector<Member<ShowContextMenuItem>>&& value) {
  member_sub_items_ = std::move(value);
has_sub_items_ = true;
}




void ShowContextMenuItem::setType(const String& value) {
  member_type_ = value;
}

void ShowContextMenuItem::setType(String&& value) {
  member_type_ = std::move(value);
}




void ShowContextMenuItem::Trace(Visitor* visitor) const {
  visitor->Trace(member_accelerator_);
visitor->Trace(member_sub_items_);
bindings::InputDictionaryBase::Trace(visitor);
}

void ShowContextMenuItem::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "ShowContextMenuItem";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("accelerator");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<Accelerator, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_accelerator_, member_accelerator_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("checked");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_checked_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("enabled");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_enabled_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("featureName");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_feature_name_, member_feature_name_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("id");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedShortEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_id_, member_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("isDevToolsPerformanceMenuItem");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_is_dev_tools_performance_menu_item_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("isExperimentalFeature");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_is_experimental_feature_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("label");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_label_, member_label_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("subItems");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<ShowContextMenuItem>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_sub_items_, member_sub_items_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("type");
constexpr bool is_required = true;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), fallback_presence_var, member_type_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> ShowContextMenuItem::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
