// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SCROLL_TIMELINE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SCROLL_TIMELINE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_scroll_axis.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class Element;
class ExceptionState;

class CORE_EXPORT ScrollTimelineOptions : public bindings::InputDictionaryBase {
  
  public:
static ScrollTimelineOptions* Create() {
  return MakeGarbageCollected<ScrollTimelineOptions>();
}
static ScrollTimelineOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ScrollTimelineOptions>(isolate);
}
static ScrollTimelineOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ScrollTimelineOptions();
explicit  ScrollTimelineOptions(v8::Isolate* isolate);

bool hasAxis() const {
  return true;
}
V8ScrollAxis axis() const {
  return member_axis_;
}
void setAxis(V8ScrollAxis value) {
  member_axis_ = value;
}
void setAxis(V8ScrollAxis::Enum value) {
  member_axis_ = V8ScrollAxis(value);
}

bool hasSource() const {
  return has_source_;
}
Element* source() const {
  DCHECK(hasSource());
return member_source_.Get();
}
Element* getSourceOr(Element* fallback_value) const {
  if (!hasSource()) {
  return fallback_value;
}
return member_source_.Get();
}
void setSource(Element* value) {
  member_source_ = value;
has_source_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_source_ = false;

V8ScrollAxis member_axis_{V8ScrollAxis::Enum::kBlock};
Member<Element> member_source_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SCROLL_TIMELINE_OPTIONS_H_
