// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_sanitizer_config.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_sanitizer_attribute_namespace.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_sanitizer_element_namespace.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_sanitizer_element_namespace_with_attributes.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_sanitizerattributenamespace_string.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_sanitizerelementnamespace_string.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_sanitizerelementnamespacewithattributes_string.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"attributes",
"comments",
"dataAttributes",
"elements",
"removeAttributes",
"removeElements",
"replaceWithChildrenElements",
};


}  // namespace 

SanitizerConfig* SanitizerConfig::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  SanitizerConfig* dictionary = MakeGarbageCollected<SanitizerConfig>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "SanitizerConfig";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 SanitizerConfig::SanitizerConfig() {
  
}

 SanitizerConfig::SanitizerConfig(v8::Isolate* isolate) {
  
}



HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>> SanitizerConfig::getAttributesOr(const HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>& fallback_value) const {
  if (!hasAttributes()) {
  return fallback_value;
}
return member_attributes_;
}

HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>> SanitizerConfig::getAttributesOr(HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>&& fallback_value) const {
  if (!hasAttributes()) {
  return std::move(fallback_value);
}
return member_attributes_;
}

void SanitizerConfig::setAttributes(const HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>& value) {
  member_attributes_ = value;
has_attributes_ = true;
}

void SanitizerConfig::setAttributes(HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>&& value) {
  member_attributes_ = std::move(value);
has_attributes_ = true;
}


















HeapVector<Member<V8UnionSanitizerElementNamespaceWithAttributesOrString>> SanitizerConfig::getElementsOr(const HeapVector<Member<V8UnionSanitizerElementNamespaceWithAttributesOrString>>& fallback_value) const {
  if (!hasElements()) {
  return fallback_value;
}
return member_elements_;
}

HeapVector<Member<V8UnionSanitizerElementNamespaceWithAttributesOrString>> SanitizerConfig::getElementsOr(HeapVector<Member<V8UnionSanitizerElementNamespaceWithAttributesOrString>>&& fallback_value) const {
  if (!hasElements()) {
  return std::move(fallback_value);
}
return member_elements_;
}

void SanitizerConfig::setElements(const HeapVector<Member<V8UnionSanitizerElementNamespaceWithAttributesOrString>>& value) {
  member_elements_ = value;
has_elements_ = true;
}

void SanitizerConfig::setElements(HeapVector<Member<V8UnionSanitizerElementNamespaceWithAttributesOrString>>&& value) {
  member_elements_ = std::move(value);
has_elements_ = true;
}




HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>> SanitizerConfig::getRemoveAttributesOr(const HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>& fallback_value) const {
  if (!hasRemoveAttributes()) {
  return fallback_value;
}
return member_remove_attributes_;
}

HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>> SanitizerConfig::getRemoveAttributesOr(HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>&& fallback_value) const {
  if (!hasRemoveAttributes()) {
  return std::move(fallback_value);
}
return member_remove_attributes_;
}

void SanitizerConfig::setRemoveAttributes(const HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>& value) {
  member_remove_attributes_ = value;
has_remove_attributes_ = true;
}

void SanitizerConfig::setRemoveAttributes(HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>&& value) {
  member_remove_attributes_ = std::move(value);
has_remove_attributes_ = true;
}




HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>> SanitizerConfig::getRemoveElementsOr(const HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>>& fallback_value) const {
  if (!hasRemoveElements()) {
  return fallback_value;
}
return member_remove_elements_;
}

HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>> SanitizerConfig::getRemoveElementsOr(HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>>&& fallback_value) const {
  if (!hasRemoveElements()) {
  return std::move(fallback_value);
}
return member_remove_elements_;
}

void SanitizerConfig::setRemoveElements(const HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>>& value) {
  member_remove_elements_ = value;
has_remove_elements_ = true;
}

void SanitizerConfig::setRemoveElements(HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>>&& value) {
  member_remove_elements_ = std::move(value);
has_remove_elements_ = true;
}




HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>> SanitizerConfig::getReplaceWithChildrenElementsOr(const HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>>& fallback_value) const {
  if (!hasReplaceWithChildrenElements()) {
  return fallback_value;
}
return member_replace_with_children_elements_;
}

HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>> SanitizerConfig::getReplaceWithChildrenElementsOr(HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>>&& fallback_value) const {
  if (!hasReplaceWithChildrenElements()) {
  return std::move(fallback_value);
}
return member_replace_with_children_elements_;
}

void SanitizerConfig::setReplaceWithChildrenElements(const HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>>& value) {
  member_replace_with_children_elements_ = value;
has_replace_with_children_elements_ = true;
}

void SanitizerConfig::setReplaceWithChildrenElements(HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>>&& value) {
  member_replace_with_children_elements_ = std::move(value);
has_replace_with_children_elements_ = true;
}




void SanitizerConfig::Trace(Visitor* visitor) const {
  visitor->Trace(member_attributes_);
visitor->Trace(member_elements_);
visitor->Trace(member_remove_attributes_);
visitor->Trace(member_remove_elements_);
visitor->Trace(member_replace_with_children_elements_);
bindings::DictionaryBase::Trace(visitor);
}

void SanitizerConfig::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void SanitizerConfig::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAttributes()) {
  values[0] = ToV8Traits<IDLSequence<V8UnionSanitizerAttributeNamespaceOrString>>::ToV8(script_state, member_attributes_);
DCHECK(!values[0].IsEmpty());
}
if (hasComments()) {
  values[1] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_comments_);
DCHECK(!values[1].IsEmpty());
}
if (hasDataAttributes()) {
  values[2] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_data_attributes_);
DCHECK(!values[2].IsEmpty());
}
if (hasElements()) {
  values[3] = ToV8Traits<IDLSequence<V8UnionSanitizerElementNamespaceWithAttributesOrString>>::ToV8(script_state, member_elements_);
DCHECK(!values[3].IsEmpty());
}
if (hasRemoveAttributes()) {
  values[4] = ToV8Traits<IDLSequence<V8UnionSanitizerAttributeNamespaceOrString>>::ToV8(script_state, member_remove_attributes_);
DCHECK(!values[4].IsEmpty());
}
if (hasRemoveElements()) {
  values[5] = ToV8Traits<IDLSequence<V8UnionSanitizerElementNamespaceOrString>>::ToV8(script_state, member_remove_elements_);
DCHECK(!values[5].IsEmpty());
}
if (hasReplaceWithChildrenElements()) {
  values[6] = ToV8Traits<IDLSequence<V8UnionSanitizerElementNamespaceOrString>>::ToV8(script_state, member_replace_with_children_elements_);
DCHECK(!values[6].IsEmpty());
}
}

const void* SanitizerConfig::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> SanitizerConfig::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void SanitizerConfig::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "SanitizerConfig";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("attributes");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8UnionSanitizerAttributeNamespaceOrString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_attributes_, member_attributes_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("comments");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_comments_, member_comments_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("dataAttributes");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_data_attributes_, member_data_attributes_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("elements");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8UnionSanitizerElementNamespaceWithAttributesOrString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_elements_, member_elements_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("removeAttributes");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8UnionSanitizerAttributeNamespaceOrString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_remove_attributes_, member_remove_attributes_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("removeElements");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8UnionSanitizerElementNamespaceOrString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_remove_elements_, member_remove_elements_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("replaceWithChildrenElements");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8UnionSanitizerElementNamespaceOrString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_replace_with_children_elements_, member_replace_with_children_elements_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> SanitizerConfig::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
