// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_RESPONSE_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_RESPONSE_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class V8UnionByteStringByteStringRecordOrByteStringSequenceSequence;

class CORE_EXPORT ResponseInit : public bindings::InputDictionaryBase {
  
  public:
static ResponseInit* Create() {
  return MakeGarbageCollected<ResponseInit>();
}
static ResponseInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ResponseInit>(isolate);
}
static ResponseInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ResponseInit();
explicit  ResponseInit(v8::Isolate* isolate);

bool hasHeaders() const {
  return has_headers_;
}
V8UnionByteStringByteStringRecordOrByteStringSequenceSequence* headers() const {
  DCHECK(hasHeaders());
return member_headers_.Get();
}
V8UnionByteStringByteStringRecordOrByteStringSequenceSequence* getHeadersOr(V8UnionByteStringByteStringRecordOrByteStringSequenceSequence* fallback_value) const {
  if (!hasHeaders()) {
  return fallback_value;
}
return member_headers_.Get();
}
void setHeaders(V8UnionByteStringByteStringRecordOrByteStringSequenceSequence* value) {
  member_headers_ = value;
has_headers_ = true;
DCHECK(member_headers_);
}

bool hasStatus() const {
  return true;
}
uint16_t status() const {
  return member_status_;
}
void setStatus(uint16_t value) {
  member_status_ = value;
}

bool hasStatusText() const {
  return true;
}
const String& statusText() const {
  return member_status_text_;
}
void setStatusText(const String& value);
void setStatusText(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_headers_ = false;

Member<V8UnionByteStringByteStringRecordOrByteStringSequenceSequence> member_headers_;
uint16_t member_status_{200};
String member_status_text_{""};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_RESPONSE_INIT_H_
