// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_REQUEST_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_REQUEST_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_fetch_priority.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_ip_address_space.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_referrer_policy.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_request_cache.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_request_credentials.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_request_duplex.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_request_mode.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_request_redirect.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AbortSignal;
class AttributionReportingRequestOptions;
class ExceptionState;
class PrivateToken;
class RetryOptions;
class V8UnionByteStringByteStringRecordOrByteStringSequenceSequence;

class CORE_EXPORT RequestInit : public bindings::InputDictionaryBase {
  
  public:
static RequestInit* Create() {
  return MakeGarbageCollected<RequestInit>();
}
static RequestInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RequestInit>(isolate);
}
static RequestInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RequestInit();
explicit  RequestInit(v8::Isolate* isolate);

bool hasAdAuctionHeaders() const {
  return has_ad_auction_headers_;
}
bool adAuctionHeaders() const {
  DCHECK(hasAdAuctionHeaders());
return member_ad_auction_headers_;
}
bool getAdAuctionHeadersOr(bool fallback_value) const {
  if (!hasAdAuctionHeaders()) {
  return fallback_value;
}
return member_ad_auction_headers_;
}
void setAdAuctionHeaders(bool value) {
  member_ad_auction_headers_ = value;
has_ad_auction_headers_ = true;
}

bool hasAttributionReporting() const {
  return has_attribution_reporting_;
}
AttributionReportingRequestOptions* attributionReporting() const {
  DCHECK(hasAttributionReporting());
return member_attribution_reporting_.Get();
}
AttributionReportingRequestOptions* getAttributionReportingOr(AttributionReportingRequestOptions* fallback_value) const {
  if (!hasAttributionReporting()) {
  return fallback_value;
}
return member_attribution_reporting_.Get();
}
void setAttributionReporting(AttributionReportingRequestOptions* value) {
  member_attribution_reporting_ = value;
has_attribution_reporting_ = true;
DCHECK(member_attribution_reporting_);
}

bool hasBody() const {
  return !member_body_.IsEmpty();
}
const ScriptValue& body() const {
  DCHECK(hasBody());
return member_body_;
}
ScriptValue getBodyOr(const ScriptValue& fallback_value) const {
  if (!hasBody()) {
  return fallback_value;
}
return member_body_;
}
void setBody(const ScriptValue& value) {
  member_body_ = value;
}

bool hasBrowsingTopics() const {
  return has_browsing_topics_;
}
bool browsingTopics() const {
  DCHECK(hasBrowsingTopics());
return member_browsing_topics_;
}
bool getBrowsingTopicsOr(bool fallback_value) const {
  if (!hasBrowsingTopics()) {
  return fallback_value;
}
return member_browsing_topics_;
}
void setBrowsingTopics(bool value) {
  member_browsing_topics_ = value;
has_browsing_topics_ = true;
}

bool hasCache() const {
  return has_cache_;
}
V8RequestCache cache() const {
  DCHECK(hasCache());
return member_cache_;
}
V8RequestCache getCacheOr(V8RequestCache fallback_value) const {
  if (!hasCache()) {
  return fallback_value;
}
return member_cache_;
}
void setCache(V8RequestCache value) {
  member_cache_ = value;
has_cache_ = true;
}
void setCache(V8RequestCache::Enum value) {
  member_cache_ = V8RequestCache(value);
has_cache_ = true;
}

bool hasCredentials() const {
  return has_credentials_;
}
V8RequestCredentials credentials() const {
  DCHECK(hasCredentials());
return member_credentials_;
}
V8RequestCredentials getCredentialsOr(V8RequestCredentials fallback_value) const {
  if (!hasCredentials()) {
  return fallback_value;
}
return member_credentials_;
}
void setCredentials(V8RequestCredentials value) {
  member_credentials_ = value;
has_credentials_ = true;
}
void setCredentials(V8RequestCredentials::Enum value) {
  member_credentials_ = V8RequestCredentials(value);
has_credentials_ = true;
}

bool hasDuplex() const {
  return has_duplex_;
}
V8RequestDuplex duplex() const {
  DCHECK(hasDuplex());
return member_duplex_;
}
V8RequestDuplex getDuplexOr(V8RequestDuplex fallback_value) const {
  if (!hasDuplex()) {
  return fallback_value;
}
return member_duplex_;
}
void setDuplex(V8RequestDuplex value) {
  member_duplex_ = value;
has_duplex_ = true;
}
void setDuplex(V8RequestDuplex::Enum value) {
  member_duplex_ = V8RequestDuplex(value);
has_duplex_ = true;
}

bool hasHeaders() const {
  return has_headers_;
}
V8UnionByteStringByteStringRecordOrByteStringSequenceSequence* headers() const {
  DCHECK(hasHeaders());
return member_headers_.Get();
}
V8UnionByteStringByteStringRecordOrByteStringSequenceSequence* getHeadersOr(V8UnionByteStringByteStringRecordOrByteStringSequenceSequence* fallback_value) const {
  if (!hasHeaders()) {
  return fallback_value;
}
return member_headers_.Get();
}
void setHeaders(V8UnionByteStringByteStringRecordOrByteStringSequenceSequence* value) {
  member_headers_ = value;
has_headers_ = true;
DCHECK(member_headers_);
}

bool hasIntegrity() const {
  return has_integrity_;
}
const String& integrity() const {
  DCHECK(hasIntegrity());
return member_integrity_;
}
String getIntegrityOr(const String& fallback_value) const;
String getIntegrityOr(String&& fallback_value) const;
void setIntegrity(const String& value);
void setIntegrity(String&& value);

bool hasKeepalive() const {
  return has_keepalive_;
}
bool keepalive() const {
  DCHECK(hasKeepalive());
return member_keepalive_;
}
bool getKeepaliveOr(bool fallback_value) const {
  if (!hasKeepalive()) {
  return fallback_value;
}
return member_keepalive_;
}
void setKeepalive(bool value) {
  member_keepalive_ = value;
has_keepalive_ = true;
}

bool hasMethod() const {
  return has_method_;
}
const String& method() const {
  DCHECK(hasMethod());
return member_method_;
}
String getMethodOr(const String& fallback_value) const;
String getMethodOr(String&& fallback_value) const;
void setMethod(const String& value);
void setMethod(String&& value);

bool hasMode() const {
  return has_mode_;
}
V8RequestMode mode() const {
  DCHECK(hasMode());
return member_mode_;
}
V8RequestMode getModeOr(V8RequestMode fallback_value) const {
  if (!hasMode()) {
  return fallback_value;
}
return member_mode_;
}
void setMode(V8RequestMode value) {
  member_mode_ = value;
has_mode_ = true;
}
void setMode(V8RequestMode::Enum value) {
  member_mode_ = V8RequestMode(value);
has_mode_ = true;
}

bool hasPriority() const {
  return has_priority_;
}
V8FetchPriority priority() const {
  DCHECK(hasPriority());
return member_priority_;
}
V8FetchPriority getPriorityOr(V8FetchPriority fallback_value) const {
  if (!hasPriority()) {
  return fallback_value;
}
return member_priority_;
}
void setPriority(V8FetchPriority value) {
  member_priority_ = value;
has_priority_ = true;
}
void setPriority(V8FetchPriority::Enum value) {
  member_priority_ = V8FetchPriority(value);
has_priority_ = true;
}

bool hasPrivateToken() const {
  return has_private_token_;
}
PrivateToken* privateToken() const {
  DCHECK(hasPrivateToken());
return member_private_token_.Get();
}
PrivateToken* getPrivateTokenOr(PrivateToken* fallback_value) const {
  if (!hasPrivateToken()) {
  return fallback_value;
}
return member_private_token_.Get();
}
void setPrivateToken(PrivateToken* value) {
  member_private_token_ = value;
has_private_token_ = true;
DCHECK(member_private_token_);
}

bool hasRedirect() const {
  return has_redirect_;
}
V8RequestRedirect redirect() const {
  DCHECK(hasRedirect());
return member_redirect_;
}
V8RequestRedirect getRedirectOr(V8RequestRedirect fallback_value) const {
  if (!hasRedirect()) {
  return fallback_value;
}
return member_redirect_;
}
void setRedirect(V8RequestRedirect value) {
  member_redirect_ = value;
has_redirect_ = true;
}
void setRedirect(V8RequestRedirect::Enum value) {
  member_redirect_ = V8RequestRedirect(value);
has_redirect_ = true;
}

bool hasReferrer() const {
  return has_referrer_;
}
const String& referrer() const {
  DCHECK(hasReferrer());
return member_referrer_;
}
String getReferrerOr(const String& fallback_value) const;
String getReferrerOr(String&& fallback_value) const;
void setReferrer(const String& value);
void setReferrer(String&& value);

bool hasReferrerPolicy() const {
  return has_referrer_policy_;
}
V8ReferrerPolicy referrerPolicy() const {
  DCHECK(hasReferrerPolicy());
return member_referrer_policy_;
}
V8ReferrerPolicy getReferrerPolicyOr(V8ReferrerPolicy fallback_value) const {
  if (!hasReferrerPolicy()) {
  return fallback_value;
}
return member_referrer_policy_;
}
void setReferrerPolicy(V8ReferrerPolicy value) {
  member_referrer_policy_ = value;
has_referrer_policy_ = true;
}
void setReferrerPolicy(V8ReferrerPolicy::Enum value) {
  member_referrer_policy_ = V8ReferrerPolicy(value);
has_referrer_policy_ = true;
}

bool hasRetryOptions() const {
  return has_retry_options_;
}
RetryOptions* retryOptions() const {
  DCHECK(hasRetryOptions());
return member_retry_options_.Get();
}
RetryOptions* getRetryOptionsOr(RetryOptions* fallback_value) const {
  if (!hasRetryOptions()) {
  return fallback_value;
}
return member_retry_options_.Get();
}
void setRetryOptions(RetryOptions* value) {
  member_retry_options_ = value;
has_retry_options_ = true;
DCHECK(member_retry_options_);
}

bool hasSharedStorageWritable() const {
  return has_shared_storage_writable_;
}
bool sharedStorageWritable() const {
  DCHECK(hasSharedStorageWritable());
return member_shared_storage_writable_;
}
bool getSharedStorageWritableOr(bool fallback_value) const {
  if (!hasSharedStorageWritable()) {
  return fallback_value;
}
return member_shared_storage_writable_;
}
void setSharedStorageWritable(bool value) {
  member_shared_storage_writable_ = value;
has_shared_storage_writable_ = true;
}

bool hasSignal() const {
  return has_signal_;
}
AbortSignal* signal() const {
  DCHECK(hasSignal());
return member_signal_.Get();
}
AbortSignal* getSignalOr(AbortSignal* fallback_value) const {
  if (!hasSignal()) {
  return fallback_value;
}
return member_signal_.Get();
}
void setSignal(AbortSignal* value) {
  member_signal_ = value;
has_signal_ = true;
}

bool hasTargetAddressSpace() const {
  return has_target_address_space_;
}
V8IPAddressSpace targetAddressSpace() const {
  DCHECK(hasTargetAddressSpace());
return member_target_address_space_;
}
V8IPAddressSpace getTargetAddressSpaceOr(V8IPAddressSpace fallback_value) const {
  if (!hasTargetAddressSpace()) {
  return fallback_value;
}
return member_target_address_space_;
}
void setTargetAddressSpace(V8IPAddressSpace value) {
  member_target_address_space_ = value;
has_target_address_space_ = true;
}
void setTargetAddressSpace(V8IPAddressSpace::Enum value) {
  member_target_address_space_ = V8IPAddressSpace(value);
has_target_address_space_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 21;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_ad_auction_headers_ = false;
bool has_attribution_reporting_ = false;
bool has_browsing_topics_ = false;
bool has_cache_ = false;
bool has_credentials_ = false;
bool has_duplex_ = false;
bool has_headers_ = false;
bool has_integrity_ = false;
bool has_keepalive_ = false;
bool has_method_ = false;
bool has_mode_ = false;
bool has_priority_ = false;
bool has_private_token_ = false;
bool has_redirect_ = false;
bool has_referrer_ = false;
bool has_referrer_policy_ = false;
bool has_retry_options_ = false;
bool has_shared_storage_writable_ = false;
bool has_signal_ = false;
bool has_target_address_space_ = false;

bool member_ad_auction_headers_;
Member<AttributionReportingRequestOptions> member_attribution_reporting_;
ScriptValue member_body_;
bool member_browsing_topics_;
V8RequestCache member_cache_{static_cast<V8RequestCache::Enum>(0)};
V8RequestCredentials member_credentials_{static_cast<V8RequestCredentials::Enum>(0)};
V8RequestDuplex member_duplex_{static_cast<V8RequestDuplex::Enum>(0)};
Member<V8UnionByteStringByteStringRecordOrByteStringSequenceSequence> member_headers_;
String member_integrity_;
bool member_keepalive_;
String member_method_;
V8RequestMode member_mode_{static_cast<V8RequestMode::Enum>(0)};
V8FetchPriority member_priority_{static_cast<V8FetchPriority::Enum>(0)};
Member<PrivateToken> member_private_token_;
V8RequestRedirect member_redirect_{static_cast<V8RequestRedirect::Enum>(0)};
String member_referrer_;
V8ReferrerPolicy member_referrer_policy_{static_cast<V8ReferrerPolicy::Enum>(0)};
Member<RetryOptions> member_retry_options_;
bool member_shared_storage_writable_;
Member<AbortSignal> member_signal_;
V8IPAddressSpace member_target_address_space_{static_cast<V8IPAddressSpace::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_REQUEST_INIT_H_
