// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PROGRESS_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PROGRESS_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/core/core_export.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT ProgressEventInit : public EventInit {
  
  public:
static ProgressEventInit* Create() {
  return MakeGarbageCollected<ProgressEventInit>();
}
static ProgressEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ProgressEventInit>(isolate);
}
static ProgressEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ProgressEventInit();
explicit  ProgressEventInit(v8::Isolate* isolate);

bool hasLengthComputable() const {
  return true;
}
bool lengthComputable() const {
  return member_length_computable_;
}
void setLengthComputable(bool value) {
  member_length_computable_ = value;
}

bool hasLoaded() const {
  return true;
}
double loaded() const {
  return member_loaded_;
}
void setLoaded(double value) {
  member_loaded_ = value;
}

bool hasTotal() const {
  return true;
}
double total() const {
  return member_total_;
}
void setTotal(double value) {
  member_total_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_length_computable_{false};
double member_loaded_{0};
double member_total_{0};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PROGRESS_EVENT_INIT_H_
