// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PART_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PART_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT PartInit : public bindings::InputDictionaryBase {
  
  public:
static PartInit* Create() {
  return MakeGarbageCollected<PartInit>();
}
static PartInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PartInit>(isolate);
}
static PartInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PartInit();
explicit  PartInit(v8::Isolate* isolate);

bool hasMetadata() const {
  return has_metadata_;
}
const Vector<String>& metadata() const {
  DCHECK(hasMetadata());
return member_metadata_;
}
Vector<String> getMetadataOr(const Vector<String>& fallback_value) const;
Vector<String> getMetadataOr(Vector<String>&& fallback_value) const;
void setMetadata(const Vector<String>& value);
void setMetadata(Vector<String>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_metadata_ = false;

Vector<String> member_metadata_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PART_INIT_H_
