// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_OBSERVER_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_OBSERVER_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class V8ObserverCallback;
class V8ObserverCompleteCallback;

class CORE_EXPORT Observer : public bindings::InputDictionaryBase {
  
  public:
static Observer* Create() {
  return MakeGarbageCollected<Observer>();
}
static Observer* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<Observer>(isolate);
}
static Observer* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  Observer();
explicit  Observer(v8::Isolate* isolate);

bool hasComplete() const {
  return has_complete_;
}
V8ObserverCompleteCallback* complete() const {
  DCHECK(hasComplete());
return member_complete_.Get();
}
V8ObserverCompleteCallback* getCompleteOr(V8ObserverCompleteCallback* fallback_value) const {
  if (!hasComplete()) {
  return fallback_value;
}
return member_complete_.Get();
}
void setComplete(V8ObserverCompleteCallback* value) {
  member_complete_ = value;
has_complete_ = true;
DCHECK(member_complete_);
}

bool hasError() const {
  return has_error_;
}
V8ObserverCallback* error() const {
  DCHECK(hasError());
return member_error_.Get();
}
V8ObserverCallback* getErrorOr(V8ObserverCallback* fallback_value) const {
  if (!hasError()) {
  return fallback_value;
}
return member_error_.Get();
}
void setError(V8ObserverCallback* value) {
  member_error_ = value;
has_error_ = true;
DCHECK(member_error_);
}

bool hasNext() const {
  return has_next_;
}
V8ObserverCallback* next() const {
  DCHECK(hasNext());
return member_next_.Get();
}
V8ObserverCallback* getNextOr(V8ObserverCallback* fallback_value) const {
  if (!hasNext()) {
  return fallback_value;
}
return member_next_.Get();
}
void setNext(V8ObserverCallback* value) {
  member_next_ = value;
has_next_ = true;
DCHECK(member_next_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_complete_ = false;
bool has_error_ = false;
bool has_next_ = false;

Member<V8ObserverCompleteCallback> member_complete_;
Member<V8ObserverCallback> member_error_;
Member<V8ObserverCallback> member_next_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_OBSERVER_H_
