// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_NAVIGATION_INTERCEPT_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_NAVIGATION_INTERCEPT_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_navigation_focus_reset.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_navigation_scroll_behavior.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class V8NavigationInterceptHandler;
class V8NavigationInterceptPrecommitHandler;

class CORE_EXPORT NavigationInterceptOptions : public bindings::InputDictionaryBase {
  
  public:
static NavigationInterceptOptions* Create() {
  return MakeGarbageCollected<NavigationInterceptOptions>();
}
static NavigationInterceptOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<NavigationInterceptOptions>(isolate);
}
static NavigationInterceptOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  NavigationInterceptOptions();
explicit  NavigationInterceptOptions(v8::Isolate* isolate);

bool hasFocusReset() const {
  return has_focus_reset_;
}
V8NavigationFocusReset focusReset() const {
  DCHECK(hasFocusReset());
return member_focus_reset_;
}
V8NavigationFocusReset getFocusResetOr(V8NavigationFocusReset fallback_value) const {
  if (!hasFocusReset()) {
  return fallback_value;
}
return member_focus_reset_;
}
void setFocusReset(V8NavigationFocusReset value) {
  member_focus_reset_ = value;
has_focus_reset_ = true;
}
void setFocusReset(V8NavigationFocusReset::Enum value) {
  member_focus_reset_ = V8NavigationFocusReset(value);
has_focus_reset_ = true;
}

bool hasHandler() const {
  return has_handler_;
}
V8NavigationInterceptHandler* handler() const {
  DCHECK(hasHandler());
return member_handler_.Get();
}
V8NavigationInterceptHandler* getHandlerOr(V8NavigationInterceptHandler* fallback_value) const {
  if (!hasHandler()) {
  return fallback_value;
}
return member_handler_.Get();
}
void setHandler(V8NavigationInterceptHandler* value) {
  member_handler_ = value;
has_handler_ = true;
DCHECK(member_handler_);
}

bool hasPrecommitHandler() const {
  return has_precommit_handler_;
}
V8NavigationInterceptPrecommitHandler* precommitHandler() const {
  DCHECK(hasPrecommitHandler());
return member_precommit_handler_.Get();
}
V8NavigationInterceptPrecommitHandler* getPrecommitHandlerOr(V8NavigationInterceptPrecommitHandler* fallback_value) const {
  if (!hasPrecommitHandler()) {
  return fallback_value;
}
return member_precommit_handler_.Get();
}
void setPrecommitHandler(V8NavigationInterceptPrecommitHandler* value) {
  member_precommit_handler_ = value;
has_precommit_handler_ = true;
DCHECK(member_precommit_handler_);
}

bool hasScroll() const {
  return has_scroll_;
}
V8NavigationScrollBehavior scroll() const {
  DCHECK(hasScroll());
return member_scroll_;
}
V8NavigationScrollBehavior getScrollOr(V8NavigationScrollBehavior fallback_value) const {
  if (!hasScroll()) {
  return fallback_value;
}
return member_scroll_;
}
void setScroll(V8NavigationScrollBehavior value) {
  member_scroll_ = value;
has_scroll_ = true;
}
void setScroll(V8NavigationScrollBehavior::Enum value) {
  member_scroll_ = V8NavigationScrollBehavior(value);
has_scroll_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_focus_reset_ = false;
bool has_handler_ = false;
bool has_precommit_handler_ = false;
bool has_scroll_ = false;

V8NavigationFocusReset member_focus_reset_{static_cast<V8NavigationFocusReset::Enum>(0)};
Member<V8NavigationInterceptHandler> member_handler_;
Member<V8NavigationInterceptPrecommitHandler> member_precommit_handler_;
V8NavigationScrollBehavior member_scroll_{static_cast<V8NavigationScrollBehavior::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_NAVIGATION_INTERCEPT_OPTIONS_H_
