// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MOUSE_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MOUSE_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_modifier_init.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class EventTarget;
class ExceptionState;

class CORE_EXPORT MouseEventInit : public EventModifierInit {
  
  public:
static MouseEventInit* Create() {
  return MakeGarbageCollected<MouseEventInit>();
}
static MouseEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MouseEventInit>(isolate);
}
static MouseEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MouseEventInit();
explicit  MouseEventInit(v8::Isolate* isolate);

bool hasButton() const {
  return true;
}
int16_t button() const {
  return member_button_;
}
void setButton(int16_t value) {
  member_button_ = value;
}

bool hasButtons() const {
  return true;
}
uint16_t buttons() const {
  return member_buttons_;
}
void setButtons(uint16_t value) {
  member_buttons_ = value;
}

bool hasClientX() const {
  return true;
}
double clientX() const {
  return member_client_x_;
}
void setClientX(double value) {
  member_client_x_ = value;
}

bool hasClientY() const {
  return true;
}
double clientY() const {
  return member_client_y_;
}
void setClientY(double value) {
  member_client_y_ = value;
}

bool hasMovementX() const {
  return true;
}
int32_t movementX() const {
  return member_movement_x_;
}
void setMovementX(int32_t value) {
  member_movement_x_ = value;
}

bool hasMovementY() const {
  return true;
}
int32_t movementY() const {
  return member_movement_y_;
}
void setMovementY(int32_t value) {
  member_movement_y_ = value;
}

bool hasRegion() const {
  return true;
}
const String& region() const {
  return member_region_;
}
void setRegion(const String& value);
void setRegion(String&& value);

bool hasRelatedTarget() const {
  return true;
}
EventTarget* relatedTarget() const {
  return member_related_target_.Get();
}
void setRelatedTarget(EventTarget* value) {
  member_related_target_ = value;
}

bool hasScreenX() const {
  return true;
}
double screenX() const {
  return member_screen_x_;
}
void setScreenX(double value) {
  member_screen_x_ = value;
}

bool hasScreenY() const {
  return true;
}
double screenY() const {
  return member_screen_y_;
}
void setScreenY(double value) {
  member_screen_y_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventModifierInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 10;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



int16_t member_button_{0};
uint16_t member_buttons_{0};
double member_client_x_{0};
double member_client_y_{0};
int32_t member_movement_x_{0};
int32_t member_movement_y_{0};
String member_region_;
Member<EventTarget> member_related_target_{nullptr};
double member_screen_x_{0};
double member_screen_y_{0};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MOUSE_EVENT_INIT_H_
