// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MOJO_HANDLE_SIGNALS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MOJO_HANDLE_SIGNALS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT MojoHandleSignals : public bindings::InputDictionaryBase {
  
  public:
static MojoHandleSignals* Create() {
  return MakeGarbageCollected<MojoHandleSignals>();
}
static MojoHandleSignals* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MojoHandleSignals>(isolate);
}
static MojoHandleSignals* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MojoHandleSignals();
explicit  MojoHandleSignals(v8::Isolate* isolate);

bool hasPeerClosed() const {
  return true;
}
bool peerClosed() const {
  return member_peer_closed_;
}
void setPeerClosed(bool value) {
  member_peer_closed_ = value;
}

bool hasReadable() const {
  return true;
}
bool readable() const {
  return member_readable_;
}
void setReadable(bool value) {
  member_readable_ = value;
}

bool hasWritable() const {
  return true;
}
bool writable() const {
  return member_writable_;
}
void setWritable(bool value) {
  member_writable_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_peer_closed_{false};
bool member_readable_{false};
bool member_writable_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MOJO_HANDLE_SIGNALS_H_
