// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MOJO_CREATE_DATA_PIPE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MOJO_CREATE_DATA_PIPE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT MojoCreateDataPipeOptions : public bindings::InputDictionaryBase {
  
  public:
static MojoCreateDataPipeOptions* Create() {
  return MakeGarbageCollected<MojoCreateDataPipeOptions>();
}
static MojoCreateDataPipeOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MojoCreateDataPipeOptions>(isolate);
}
static MojoCreateDataPipeOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MojoCreateDataPipeOptions();
explicit  MojoCreateDataPipeOptions(v8::Isolate* isolate);

bool hasCapacityNumBytes() const {
  return has_capacity_num_bytes_;
}
uint32_t capacityNumBytes() const {
  DCHECK(hasCapacityNumBytes());
return member_capacity_num_bytes_;
}
uint32_t getCapacityNumBytesOr(uint32_t fallback_value) const {
  if (!hasCapacityNumBytes()) {
  return fallback_value;
}
return member_capacity_num_bytes_;
}
void setCapacityNumBytes(uint32_t value) {
  member_capacity_num_bytes_ = value;
has_capacity_num_bytes_ = true;
}

bool hasElementNumBytes() const {
  return has_element_num_bytes_;
}
uint32_t elementNumBytes() const {
  DCHECK(hasElementNumBytes());
return member_element_num_bytes_;
}
uint32_t getElementNumBytesOr(uint32_t fallback_value) const {
  if (!hasElementNumBytes()) {
  return fallback_value;
}
return member_element_num_bytes_;
}
void setElementNumBytes(uint32_t value) {
  member_element_num_bytes_ = value;
has_element_num_bytes_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_capacity_num_bytes_ = false;
bool has_element_num_bytes_ = false;

uint32_t member_capacity_num_bytes_;
uint32_t member_element_num_bytes_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MOJO_CREATE_DATA_PIPE_OPTIONS_H_
