// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_memory_breakdown_entry.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_memory_attribution.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"attribution",
"bytes",
"types",
};


}  // namespace 

MemoryBreakdownEntry* MemoryBreakdownEntry::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  MemoryBreakdownEntry* dictionary = MakeGarbageCollected<MemoryBreakdownEntry>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "MemoryBreakdownEntry";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 MemoryBreakdownEntry::MemoryBreakdownEntry() {
  
}

 MemoryBreakdownEntry::MemoryBreakdownEntry(v8::Isolate* isolate) {
  
}



void MemoryBreakdownEntry::setAttribution(const HeapVector<Member<MemoryAttribution>>& value) {
  member_attribution_ = value;
}

void MemoryBreakdownEntry::setAttribution(HeapVector<Member<MemoryAttribution>>&& value) {
  member_attribution_ = std::move(value);
}









void MemoryBreakdownEntry::setTypes(const Vector<String>& value) {
  member_types_ = value;
}

void MemoryBreakdownEntry::setTypes(Vector<String>&& value) {
  member_types_ = std::move(value);
}




void MemoryBreakdownEntry::Trace(Visitor* visitor) const {
  visitor->Trace(member_attribution_);
bindings::DictionaryBase::Trace(visitor);
}

void MemoryBreakdownEntry::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void MemoryBreakdownEntry::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAttribution()) {
  values[0] = ToV8Traits<IDLSequence<MemoryAttribution>>::ToV8(script_state, member_attribution_);
DCHECK(!values[0].IsEmpty());
}
if (hasBytes()) {
  values[1] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_bytes_);
DCHECK(!values[1].IsEmpty());
}
if (hasTypes()) {
  values[2] = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_types_);
DCHECK(!values[2].IsEmpty());
}
}

const void* MemoryBreakdownEntry::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> MemoryBreakdownEntry::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void MemoryBreakdownEntry::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "MemoryBreakdownEntry";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("attribution");
constexpr bool is_required = true;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<MemoryAttribution>, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_attribution_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("bytes");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_bytes_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("types");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_types_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> MemoryBreakdownEntry::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
