// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_KEYBOARD_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_KEYBOARD_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_modifier_init.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT KeyboardEventInit : public EventModifierInit {
  
  public:
static KeyboardEventInit* Create() {
  return MakeGarbageCollected<KeyboardEventInit>();
}
static KeyboardEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<KeyboardEventInit>(isolate);
}
static KeyboardEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  KeyboardEventInit();
explicit  KeyboardEventInit(v8::Isolate* isolate);

bool hasCharCode() const {
  return true;
}
uint32_t charCode() const {
  return member_char_code_;
}
void setCharCode(uint32_t value) {
  member_char_code_ = value;
}

bool hasCode() const {
  return true;
}
const String& code() const {
  return member_code_;
}
void setCode(const String& value);
void setCode(String&& value);

bool hasIsComposing() const {
  return true;
}
bool isComposing() const {
  return member_is_composing_;
}
void setIsComposing(bool value) {
  member_is_composing_ = value;
}

bool hasKey() const {
  return true;
}
const String& key() const {
  return member_key_;
}
void setKey(const String& value);
void setKey(String&& value);

bool hasKeyCode() const {
  return true;
}
uint32_t keyCode() const {
  return member_key_code_;
}
void setKeyCode(uint32_t value) {
  member_key_code_ = value;
}

bool hasLocation() const {
  return true;
}
uint32_t location() const {
  return member_location_;
}
void setLocation(uint32_t value) {
  member_location_ = value;
}

bool hasRepeat() const {
  return true;
}
bool repeat() const {
  return member_repeat_;
}
void setRepeat(bool value) {
  member_repeat_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventModifierInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



uint32_t member_char_code_{0};
String member_code_{""};
bool member_is_composing_{false};
String member_key_{""};
uint32_t member_key_code_{0};
uint32_t member_location_{0};
bool member_repeat_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_KEYBOARD_EVENT_INIT_H_
