// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_input_event_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/core/clipboard/data_transfer.h"
#include "third_party/blink/renderer/core/dom/static_range.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"data",
"dataTransfer",
"inputType",
"isComposing",
"targetRanges",
};


}  // namespace 

InputEventInit* InputEventInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  InputEventInit* dictionary = MakeGarbageCollected<InputEventInit>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "InputEventInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 InputEventInit::InputEventInit() {
  
}

 InputEventInit::InputEventInit(v8::Isolate* isolate) : UIEventInit(isolate) {
  
}



String InputEventInit::getDataOr(const String& fallback_value) const {
  if (!hasData()) {
  return fallback_value;
}
return member_data_;
}

String InputEventInit::getDataOr(String&& fallback_value) const {
  if (!hasData()) {
  return std::move(fallback_value);
}
return member_data_;
}

void InputEventInit::setData(const String& value) {
  member_data_ = value;
has_data_ = true;
}

void InputEventInit::setData(String&& value) {
  member_data_ = std::move(value);
has_data_ = true;
}











void InputEventInit::setInputType(const String& value) {
  member_input_type_ = value;
}

void InputEventInit::setInputType(String&& value) {
  member_input_type_ = std::move(value);
}









void InputEventInit::setTargetRanges(const HeapVector<Member<StaticRange>>& value) {
  member_target_ranges_ = value;
}

void InputEventInit::setTargetRanges(HeapVector<Member<StaticRange>>&& value) {
  member_target_ranges_ = std::move(value);
}




void InputEventInit::Trace(Visitor* visitor) const {
  visitor->Trace(member_data_transfer_);
visitor->Trace(member_target_ranges_);
UIEventInit::Trace(visitor);
}

void InputEventInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
UIEventInit::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "InputEventInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("data");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_data_, member_data_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("dataTransfer");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<DataTransfer>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_data_transfer_, member_data_transfer_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("inputType");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_input_type_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("isComposing");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_is_composing_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("targetRanges");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<StaticRange>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_target_ranges_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> InputEventInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
