// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_IMPORT_NODE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_IMPORT_NODE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class CustomElementRegistry;
class ExceptionState;

class CORE_EXPORT ImportNodeOptions : public bindings::InputDictionaryBase {
  
  public:
static ImportNodeOptions* Create() {
  return MakeGarbageCollected<ImportNodeOptions>();
}
static ImportNodeOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ImportNodeOptions>(isolate);
}
static ImportNodeOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ImportNodeOptions();
explicit  ImportNodeOptions(v8::Isolate* isolate);

bool hasCustomElementRegistry() const {
  return has_custom_element_registry_;
}
CustomElementRegistry* customElementRegistry() const {
  DCHECK(hasCustomElementRegistry());
return member_custom_element_registry_.Get();
}
CustomElementRegistry* getCustomElementRegistryOr(CustomElementRegistry* fallback_value) const {
  if (!hasCustomElementRegistry()) {
  return fallback_value;
}
return member_custom_element_registry_.Get();
}
void setCustomElementRegistry(CustomElementRegistry* value) {
  member_custom_element_registry_ = value;
has_custom_element_registry_ = true;
DCHECK(member_custom_element_registry_);
}

bool hasSelfOnly() const {
  return true;
}
bool selfOnly() const {
  return member_self_only_;
}
void setSelfOnly(bool value) {
  member_self_only_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_custom_element_registry_ = false;

Member<CustomElementRegistry> member_custom_element_registry_;
bool member_self_only_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_IMPORT_NODE_OPTIONS_H_
