// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_form_control_range.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_abstract_range.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_node.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/core/dom/form_control_range.h"
#include "third_party/blink/renderer/core/dom/node.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/v8_object_constructor.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {



bool V8FormControlRange::IsExposed(ExecutionContext* execution_context) {
  
return execution_context->IsWindow() && RuntimeEnabledFeatures::FormControlRangeEnabled();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8FormControlRange::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8FormControlRange::InstallInterfaceTemplate,
    nullptr,
    "FormControlRange",
    V8AbstractRange::GetWrapperTypeInfo(),
    V8FormControlRange::kThisTag,
    V8FormControlRange::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& FormControlRange::wrapper_type_info_ =
    V8FormControlRange::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, FormControlRange>::value,
    "FormControlRange inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_form_control_range {

void ConstructorCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_FormControlRange_constructor");
BLINK_BINDINGS_TRACE_EVENT("FormControlRange.constructor");

v8::Isolate* isolate = info.GetIsolate();
if (!info.IsConstructCall()) {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::ConstructorCalledAsFunction());
return;
}
v8::Local<v8::Object> v8_receiver = info.This();
if (ConstructorMode::Current(isolate) == ConstructorMode::kWrapExistingObject) {
  bindings::V8SetReturnValue(info, v8_receiver);
return;
}



v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
ExecutionContext* execution_context = current_execution_context;
auto&& return_value = FormControlRange::Create(*bindings::ToDocumentFromExecutionContext(execution_context));
static_assert(bindings::IsReturnTypeCompatible<FormControlRange, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Object> v8_wrapper = return_value->AssociateWithWrapper(isolate, V8FormControlRange::GetWrapperTypeInfo(), v8_receiver);
bindings::V8SetReturnValue(info, v8_wrapper);
}

void SetFormControlRangeOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_FormControlRange_setFormControlRange");
BLINK_BINDINGS_TRACE_EVENT("FormControlRange.setFormControlRange");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
FormControlRange* blink_receiver = V8FormControlRange::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_element = NativeValueTraits<Node>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_start = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_end = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setFormControlRange(arg1_element, arg2_start, arg3_end, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void ToStringOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_FormControlRange_toString");
BLINK_BINDINGS_TRACE_EVENT("FormControlRange.toString");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
FormControlRange* blink_receiver = V8FormControlRange::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->toString();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}


}  // namespace v8_form_control_range

using namespace v8_form_control_range;

}  // namespace 

void V8FormControlRange::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8FormControlRange::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template = wrapper_type_info->parent_class->GetV8ClassTemplate(isolate, world).As<v8::FunctionTemplate>();
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);

interface_function_template->SetCallHandler(ConstructorCallback);
interface_function_template->SetLength(0);
interface_function_template->SetInterfaceName(V8String(isolate, "FormControlRange"));
interface_function_template->SetExceptionContext(v8::ExceptionContext::kConstructor);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8FormControlRange::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"setFormControlRange", SetFormControlRangeOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"toString", ToStringOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect)}, 
};
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "FormControlRange", kOperationTable);
}



}




}  // namespace blink
