// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_FENCE_EVENT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_FENCE_EVENT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_fence_reporting_destination.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT FenceEvent : public bindings::InputDictionaryBase {
  
  public:
static FenceEvent* Create() {
  return MakeGarbageCollected<FenceEvent>();
}
static FenceEvent* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<FenceEvent>(isolate);
}
static FenceEvent* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  FenceEvent();
explicit  FenceEvent(v8::Isolate* isolate);

bool hasCrossOriginExposed() const {
  return true;
}
bool crossOriginExposed() const {
  return member_cross_origin_exposed_;
}
void setCrossOriginExposed(bool value) {
  member_cross_origin_exposed_ = value;
}

bool hasDestination() const {
  return has_destination_;
}
const Vector<V8FenceReportingDestination>& destination() const {
  DCHECK(hasDestination());
return member_destination_;
}
Vector<V8FenceReportingDestination> getDestinationOr(const Vector<V8FenceReportingDestination>& fallback_value) const;
Vector<V8FenceReportingDestination> getDestinationOr(Vector<V8FenceReportingDestination>&& fallback_value) const;
void setDestination(const Vector<V8FenceReportingDestination>& value);
void setDestination(Vector<V8FenceReportingDestination>&& value);

bool hasDestinationURL() const {
  return has_destination_url_;
}
const String& destinationURL() const {
  DCHECK(hasDestinationURL());
return member_destination_url_;
}
String getDestinationURLOr(const String& fallback_value) const;
String getDestinationURLOr(String&& fallback_value) const;
void setDestinationURL(const String& value);
void setDestinationURL(String&& value);

bool hasEventData() const {
  return has_event_data_;
}
const String& eventData() const {
  DCHECK(hasEventData());
return member_event_data_;
}
String getEventDataOr(const String& fallback_value) const;
String getEventDataOr(String&& fallback_value) const;
void setEventData(const String& value);
void setEventData(String&& value);

bool hasEventType() const {
  return has_event_type_;
}
const String& eventType() const {
  DCHECK(hasEventType());
return member_event_type_;
}
String getEventTypeOr(const String& fallback_value) const;
String getEventTypeOr(String&& fallback_value) const;
void setEventType(const String& value);
void setEventType(String&& value);

bool hasOnce() const {
  return true;
}
bool once() const {
  return member_once_;
}
void setOnce(bool value) {
  member_once_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_destination_ = false;
bool has_destination_url_ = false;
bool has_event_data_ = false;
bool has_event_type_ = false;

bool member_cross_origin_exposed_{false};
Vector<V8FenceReportingDestination> member_destination_;
String member_destination_url_;
String member_event_data_;
String member_event_type_;
bool member_once_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_FENCE_EVENT_H_
