// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_event_target.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_add_event_listener_options.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_listener.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_listener_options.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_observable.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_observable_event_listener_options.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_addeventlisteneroptions_boolean.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_boolean_eventlisteneroptions.h"
#include "third_party/blink/renderer/core/dom/events/event.h"
#include "third_party/blink/renderer/core/dom/events/event_target.h"
#include "third_party/blink/renderer/core/dom/observable.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/frame/web_feature.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/v8_object_constructor.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"
#include "third_party/blink/renderer/platform/instrumentation/use_counter.h"

namespace blink {



bool V8EventTarget::IsExposed(ExecutionContext* execution_context) {
  
return execution_context->IsWindow() || execution_context->IsWorkerGlobalScope() || execution_context->IsAudioWorkletGlobalScope() || execution_context->IsShadowRealmGlobalScope();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8EventTarget::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8EventTarget::InstallInterfaceTemplate,
    nullptr,
    "EventTarget",
    nullptr,
    V8EventTarget::kThisTag,
    V8EventTarget::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& EventTarget::wrapper_type_info_ =
    V8EventTarget::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, EventTarget>::value,
    "EventTarget inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_event_target {

void ConstructorCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_EventTarget_constructor");
BLINK_BINDINGS_TRACE_EVENT("EventTarget.constructor");

v8::Isolate* isolate = info.GetIsolate();
if (!info.IsConstructCall()) {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::ConstructorCalledAsFunction());
return;
}
v8::Local<v8::Object> v8_receiver = info.This();
if (ConstructorMode::Current(isolate) == ConstructorMode::kWrapExistingObject) {
  bindings::V8SetReturnValue(info, v8_receiver);
return;
}



v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ScriptState* script_state = current_script_state;
auto&& return_value = EventTarget::Create(script_state);
static_assert(bindings::IsReturnTypeCompatible<EventTarget, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Object> v8_wrapper = return_value->AssociateWithWrapper(isolate, V8EventTarget::GetWrapperTypeInfo(), v8_receiver);
bindings::V8SetReturnValue(info, v8_wrapper);
}

void AddEventListenerOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_EventTarget_addEventListener");
BLINK_BINDINGS_TRACE_EVENT("EventTarget.addEventListener");




if (info.Length() < 2) [[unlikely]] {
  v8::Isolate* isolate = info.GetIsolate();
V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
EventTarget* blink_receiver = V8EventTarget::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_type = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_listener = NativeValueTraits<IDLNullable<V8EventListener>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
if (non_undefined_argument_length <= 2) {
  blink_receiver->addEventListener(arg1_type, arg2_listener);
break;
}
auto&& arg3_options = NativeValueTraits<V8UnionAddEventListenerOptionsOrBoolean>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->addEventListener(arg1_type, arg2_listener, arg3_options);
} while (false);

}

void DispatchEventOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE(info.GetIsolate(), RuntimeCallStats::CounterId::kEventTargetDispatchEvent);
BLINK_BINDINGS_TRACE_EVENT("EventTarget.dispatchEvent");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
EventTarget* blink_receiver = V8EventTarget::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_event = NativeValueTraits<Event>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->dispatchEventForBindings(arg1_event, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void RemoveEventListenerOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_EventTarget_removeEventListener");
BLINK_BINDINGS_TRACE_EVENT("EventTarget.removeEventListener");




if (info.Length() < 2) [[unlikely]] {
  v8::Isolate* isolate = info.GetIsolate();
V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
EventTarget* blink_receiver = V8EventTarget::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_type = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_listener = NativeValueTraits<IDLNullable<V8EventListener>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
if (non_undefined_argument_length <= 2) {
  blink_receiver->removeEventListener(arg1_type, arg2_listener);
break;
}
auto&& arg3_options = NativeValueTraits<V8UnionBooleanOrEventListenerOptions>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->removeEventListener(arg1_type, arg2_listener, arg3_options);
} while (false);

}

void WhenOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_EventTarget_when");
BLINK_BINDINGS_TRACE_EVENT("EventTarget.when");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kEventTargetOnObservable);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
EventTarget* blink_receiver = V8EventTarget::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_type = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<ObservableEventListenerOptions>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_options;
if (info[1]->IsUndefined()) {
  arg2_options = ObservableEventListenerOptions::Create();
} else {
  arg2_options = NativeValueTraits<ObservableEventListenerOptions>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = blink_receiver->when(arg1_type, arg2_options);
static_assert(bindings::IsReturnTypeCompatible<Observable, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}


}  // namespace v8_event_target

using namespace v8_event_target;

}  // namespace 

void V8EventTarget::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8EventTarget::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);

interface_function_template->SetCallHandler(ConstructorCallback);
interface_function_template->SetLength(0);
interface_function_template->SetInterfaceName(V8String(isolate, "EventTarget"));
interface_function_template->SetExceptionContext(v8::ExceptionContext::kConstructor);






// [Global] - prototype object in the prototype chain of global objects
// 3.7.1. [[SetPrototypeOf]]
// https://webidl.spec.whatwg.org/#platform-object-setprototypeof
prototype_template->SetImmutableProto();

InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8EventTarget::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"addEventListener", AddEventListenerOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"dispatchEvent", DispatchEventOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"removeEventListener", RemoveEventListenerOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"when", WhenOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "EventTarget", kOperationTable);
}



}



namespace bindings {

namespace v8_context_snapshot {

base::span<const intptr_t> GetRefTableOfV8EventTarget() {
  static const intptr_t kReferenceTable[] = {
reinterpret_cast<intptr_t>(V8EventTarget::GetWrapperTypeInfo()),
reinterpret_cast<intptr_t>(ConstructorCallback),
reinterpret_cast<intptr_t>(AddEventListenerOperationCallback),
reinterpret_cast<intptr_t>(DispatchEventOperationCallback),
reinterpret_cast<intptr_t>(RemoveEventListenerOperationCallback),
reinterpret_cast<intptr_t>(WhenOperationCallback),
};
return kReferenceTable;
}

void InstallPropsOfV8EventTarget(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;







}

void InstallPropsOfV8EventTarget(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  
}


}  // namespace v8_context_snapshot

}  // namespace bindings


}  // namespace blink
