// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_element_creation_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/core/html/custom/custom_element_registry.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"customElementRegistry",
"is",
};


}  // namespace 

ElementCreationOptions* ElementCreationOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  ElementCreationOptions* dictionary = MakeGarbageCollected<ElementCreationOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "ElementCreationOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 ElementCreationOptions::ElementCreationOptions() {
  
}

 ElementCreationOptions::ElementCreationOptions(v8::Isolate* isolate) {
  
}










String ElementCreationOptions::getIsOr(const String& fallback_value) const {
  if (!hasIs()) {
  return fallback_value;
}
return member_is_;
}

String ElementCreationOptions::getIsOr(String&& fallback_value) const {
  if (!hasIs()) {
  return std::move(fallback_value);
}
return member_is_;
}

void ElementCreationOptions::setIs(const String& value) {
  member_is_ = value;
has_is_ = true;
}

void ElementCreationOptions::setIs(String&& value) {
  member_is_ = std::move(value);
has_is_ = true;
}




void ElementCreationOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_custom_element_registry_);
bindings::InputDictionaryBase::Trace(visitor);
}

void ElementCreationOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "ElementCreationOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (RuntimeEnabledFeatures::ScopedCustomElementRegistryEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("customElementRegistry");
if (!bindings::GetDictionaryMemberFromV8Object<CustomElementRegistry, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_custom_element_registry_, member_custom_element_registry_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("is");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_is_, member_is_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> ElementCreationOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
