// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_effect_timing.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_cssnumericvalue_double.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_cssnumericvalue_string_unrestricteddouble.h"
#include "third_party/blink/renderer/core/css/cssom/css_numeric_value.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"delay",
"direction",
"duration",
"easing",
"endDelay",
"fill",
"iterationStart",
"iterations",
};


}  // namespace 

EffectTiming* EffectTiming::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  EffectTiming* dictionary = MakeGarbageCollected<EffectTiming>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "EffectTiming";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 EffectTiming::EffectTiming() : member_delay_(MakeGarbageCollected<V8UnionCSSNumericValueOrDouble>(0)), member_duration_(MakeGarbageCollected<V8UnionCSSNumericValueOrStringOrUnrestrictedDouble>("auto")), member_end_delay_(MakeGarbageCollected<V8UnionCSSNumericValueOrDouble>(0)) {
  
}

 EffectTiming::EffectTiming(v8::Isolate* isolate) : member_delay_(MakeGarbageCollected<V8UnionCSSNumericValueOrDouble>(0)), member_duration_(MakeGarbageCollected<V8UnionCSSNumericValueOrStringOrUnrestrictedDouble>("auto")), member_end_delay_(MakeGarbageCollected<V8UnionCSSNumericValueOrDouble>(0)) {
  
}


















void EffectTiming::setEasing(const String& value) {
  member_easing_ = value;
}

void EffectTiming::setEasing(String&& value) {
  member_easing_ = std::move(value);
}
























void EffectTiming::Trace(Visitor* visitor) const {
  visitor->Trace(member_delay_);
visitor->Trace(member_duration_);
visitor->Trace(member_end_delay_);
bindings::DictionaryBase::Trace(visitor);
}

void EffectTiming::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void EffectTiming::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasDelay()) {
  values[0] = ToV8Traits<V8UnionCSSNumericValueOrDouble>::ToV8(script_state, member_delay_.Get());
DCHECK(!values[0].IsEmpty());
}
if (hasDirection()) {
  values[1] = ToV8Traits<V8PlaybackDirection>::ToV8(script_state, member_direction_);
DCHECK(!values[1].IsEmpty());
}
if (hasDuration()) {
  values[2] = ToV8Traits<V8UnionCSSNumericValueOrStringOrUnrestrictedDouble>::ToV8(script_state, member_duration_.Get());
DCHECK(!values[2].IsEmpty());
}
if (hasEasing()) {
  values[3] = ToV8Traits<IDLString>::ToV8(script_state, member_easing_);
DCHECK(!values[3].IsEmpty());
}
if (hasEndDelay()) {
  values[4] = ToV8Traits<V8UnionCSSNumericValueOrDouble>::ToV8(script_state, member_end_delay_.Get());
DCHECK(!values[4].IsEmpty());
}
if (hasFill()) {
  values[5] = ToV8Traits<V8FillMode>::ToV8(script_state, member_fill_);
DCHECK(!values[5].IsEmpty());
}
if (hasIterationStart()) {
  values[6] = ToV8Traits<IDLDouble>::ToV8(script_state, member_iteration_start_);
DCHECK(!values[6].IsEmpty());
}
if (hasIterations()) {
  values[7] = ToV8Traits<IDLUnrestrictedDouble>::ToV8(script_state, member_iterations_);
DCHECK(!values[7].IsEmpty());
}
}

const void* EffectTiming::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> EffectTiming::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void EffectTiming::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "EffectTiming";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("delay");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionCSSNumericValueOrDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_delay_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("direction");
if (!bindings::GetDictionaryMemberFromV8Object<V8PlaybackDirection, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_direction_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("duration");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionCSSNumericValueOrStringOrUnrestrictedDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_duration_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("easing");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_easing_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("endDelay");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionCSSNumericValueOrDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_end_delay_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("fill");
if (!bindings::GetDictionaryMemberFromV8Object<V8FillMode, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_fill_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("iterationStart");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_iteration_start_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("iterations");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnrestrictedDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), fallback_presence_var, member_iterations_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> EffectTiming::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
