// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CUSTOM_LAYOUT_CONSTRAINTS_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CUSTOM_LAYOUT_CONSTRAINTS_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT CustomLayoutConstraintsOptions : public bindings::InputDictionaryBase {
  
  public:
static CustomLayoutConstraintsOptions* Create() {
  return MakeGarbageCollected<CustomLayoutConstraintsOptions>();
}
static CustomLayoutConstraintsOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CustomLayoutConstraintsOptions>(isolate);
}
static CustomLayoutConstraintsOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CustomLayoutConstraintsOptions();
explicit  CustomLayoutConstraintsOptions(v8::Isolate* isolate);

bool hasAvailableBlockSize() const {
  return has_available_block_size_;
}
double availableBlockSize() const {
  DCHECK(hasAvailableBlockSize());
return member_available_block_size_;
}
double getAvailableBlockSizeOr(double fallback_value) const {
  if (!hasAvailableBlockSize()) {
  return fallback_value;
}
return member_available_block_size_;
}
void setAvailableBlockSize(double value) {
  member_available_block_size_ = value;
has_available_block_size_ = true;
}

bool hasAvailableInlineSize() const {
  return has_available_inline_size_;
}
double availableInlineSize() const {
  DCHECK(hasAvailableInlineSize());
return member_available_inline_size_;
}
double getAvailableInlineSizeOr(double fallback_value) const {
  if (!hasAvailableInlineSize()) {
  return fallback_value;
}
return member_available_inline_size_;
}
void setAvailableInlineSize(double value) {
  member_available_inline_size_ = value;
has_available_inline_size_ = true;
}

bool hasData() const {
  return !member_data_.IsEmpty();
}
const ScriptValue& data() const {
  DCHECK(hasData());
return member_data_;
}
ScriptValue getDataOr(const ScriptValue& fallback_value) const {
  if (!hasData()) {
  return fallback_value;
}
return member_data_;
}
void setData(const ScriptValue& value) {
  member_data_ = value;
}

bool hasFixedBlockSize() const {
  return has_fixed_block_size_;
}
double fixedBlockSize() const {
  DCHECK(hasFixedBlockSize());
return member_fixed_block_size_;
}
double getFixedBlockSizeOr(double fallback_value) const {
  if (!hasFixedBlockSize()) {
  return fallback_value;
}
return member_fixed_block_size_;
}
void setFixedBlockSize(double value) {
  member_fixed_block_size_ = value;
has_fixed_block_size_ = true;
}

bool hasFixedInlineSize() const {
  return has_fixed_inline_size_;
}
double fixedInlineSize() const {
  DCHECK(hasFixedInlineSize());
return member_fixed_inline_size_;
}
double getFixedInlineSizeOr(double fallback_value) const {
  if (!hasFixedInlineSize()) {
  return fallback_value;
}
return member_fixed_inline_size_;
}
void setFixedInlineSize(double value) {
  member_fixed_inline_size_ = value;
has_fixed_inline_size_ = true;
}

bool hasPercentageBlockSize() const {
  return has_percentage_block_size_;
}
double percentageBlockSize() const {
  DCHECK(hasPercentageBlockSize());
return member_percentage_block_size_;
}
double getPercentageBlockSizeOr(double fallback_value) const {
  if (!hasPercentageBlockSize()) {
  return fallback_value;
}
return member_percentage_block_size_;
}
void setPercentageBlockSize(double value) {
  member_percentage_block_size_ = value;
has_percentage_block_size_ = true;
}

bool hasPercentageInlineSize() const {
  return has_percentage_inline_size_;
}
double percentageInlineSize() const {
  DCHECK(hasPercentageInlineSize());
return member_percentage_inline_size_;
}
double getPercentageInlineSizeOr(double fallback_value) const {
  if (!hasPercentageInlineSize()) {
  return fallback_value;
}
return member_percentage_inline_size_;
}
void setPercentageInlineSize(double value) {
  member_percentage_inline_size_ = value;
has_percentage_inline_size_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_available_block_size_ = false;
bool has_available_inline_size_ = false;
bool has_fixed_block_size_ = false;
bool has_fixed_inline_size_ = false;
bool has_percentage_block_size_ = false;
bool has_percentage_inline_size_ = false;

double member_available_block_size_;
double member_available_inline_size_;
ScriptValue member_data_;
double member_fixed_block_size_;
double member_fixed_inline_size_;
double member_percentage_block_size_;
double member_percentage_inline_size_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CUSTOM_LAYOUT_CONSTRAINTS_OPTIONS_H_
