// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_COMPUTED_EFFECT_TIMING_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_COMPUTED_EFFECT_TIMING_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_effect_timing.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class CSSNumericValue;
class ExceptionState;
class V8UnionCSSNumericValueOrDouble;

class CORE_EXPORT ComputedEffectTiming : public EffectTiming {
  
  public:
static ComputedEffectTiming* Create() {
  return MakeGarbageCollected<ComputedEffectTiming>();
}
static ComputedEffectTiming* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ComputedEffectTiming>(isolate);
}
static ComputedEffectTiming* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ComputedEffectTiming();
explicit  ComputedEffectTiming(v8::Isolate* isolate);

bool hasActiveDuration() const {
  return has_active_duration_;
}
V8UnionCSSNumericValueOrDouble* activeDuration() const {
  DCHECK(hasActiveDuration());
return member_active_duration_.Get();
}
V8UnionCSSNumericValueOrDouble* getActiveDurationOr(V8UnionCSSNumericValueOrDouble* fallback_value) const {
  if (!hasActiveDuration()) {
  return fallback_value;
}
return member_active_duration_.Get();
}
void setActiveDuration(V8UnionCSSNumericValueOrDouble* value) {
  member_active_duration_ = value;
has_active_duration_ = true;
DCHECK(member_active_duration_);
}

bool hasCurrentIteration() const {
  return has_current_iteration_;
}
const std::optional<double>& currentIteration() const {
  DCHECK(hasCurrentIteration());
return member_current_iteration_;
}
std::optional<double> getCurrentIterationOr(const std::optional<double>& fallback_value) const {
  if (!hasCurrentIteration()) {
  return fallback_value;
}
return member_current_iteration_;
}
void setCurrentIteration(const std::optional<double>& value) {
  member_current_iteration_ = value;
has_current_iteration_ = true;
}
void setCurrentIteration(double value) {
  member_current_iteration_ = value;
has_current_iteration_ = true;
}

bool hasEndTime() const {
  return has_end_time_;
}
V8UnionCSSNumericValueOrDouble* endTime() const {
  DCHECK(hasEndTime());
return member_end_time_.Get();
}
V8UnionCSSNumericValueOrDouble* getEndTimeOr(V8UnionCSSNumericValueOrDouble* fallback_value) const {
  if (!hasEndTime()) {
  return fallback_value;
}
return member_end_time_.Get();
}
void setEndTime(V8UnionCSSNumericValueOrDouble* value) {
  member_end_time_ = value;
has_end_time_ = true;
DCHECK(member_end_time_);
}

bool hasLocalTime() const {
  return has_local_time_;
}
V8UnionCSSNumericValueOrDouble* localTime() const {
  DCHECK(hasLocalTime());
return member_local_time_.Get();
}
V8UnionCSSNumericValueOrDouble* getLocalTimeOr(V8UnionCSSNumericValueOrDouble* fallback_value) const {
  if (!hasLocalTime()) {
  return fallback_value;
}
return member_local_time_.Get();
}
void setLocalTime(V8UnionCSSNumericValueOrDouble* value) {
  member_local_time_ = value;
has_local_time_ = true;
}

bool hasProgress() const {
  return has_progress_;
}
const std::optional<double>& progress() const {
  DCHECK(hasProgress());
return member_progress_;
}
std::optional<double> getProgressOr(const std::optional<double>& fallback_value) const {
  if (!hasProgress()) {
  return fallback_value;
}
return member_progress_;
}
void setProgress(const std::optional<double>& value) {
  member_progress_ = value;
has_progress_ = true;
}
void setProgress(double value) {
  member_progress_ = value;
has_progress_ = true;
}


// Obsolete accessor functions
bool hasCurrentIterationNonNull() const {
  return hasCurrentIteration() && currentIteration().has_value();
}
double currentIterationNonNull() const {
  DCHECK(hasCurrentIterationNonNull());
return currentIteration().value();
}
bool hasProgressNonNull() const {
  return hasProgress() && progress().has_value();
}
double progressNonNull() const {
  DCHECK(hasProgressNonNull());
return progress().value();
}

void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EffectTiming::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_active_duration_ = false;
bool has_current_iteration_ = false;
bool has_end_time_ = false;
bool has_local_time_ = false;
bool has_progress_ = false;

Member<V8UnionCSSNumericValueOrDouble> member_active_duration_;
std::optional<double> member_current_iteration_;
Member<V8UnionCSSNumericValueOrDouble> member_end_time_;
Member<V8UnionCSSNumericValueOrDouble> member_local_time_;
std::optional<double> member_progress_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_COMPUTED_EFFECT_TIMING_H_
