// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CANVAS_SMPTE_ST_2086_METADATA_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CANVAS_SMPTE_ST_2086_METADATA_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT CanvasSmpteSt2086Metadata : public bindings::InputDictionaryBase {
  
  public:
static CanvasSmpteSt2086Metadata* Create() {
  return MakeGarbageCollected<CanvasSmpteSt2086Metadata>();
}
static CanvasSmpteSt2086Metadata* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CanvasSmpteSt2086Metadata>(isolate);
}
static CanvasSmpteSt2086Metadata* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CanvasSmpteSt2086Metadata();
explicit  CanvasSmpteSt2086Metadata(v8::Isolate* isolate);

bool hasBluePrimaryX() const {
  return true;
}
float bluePrimaryX() const {
  return member_blue_primary_x_;
}
void setBluePrimaryX(float value) {
  member_blue_primary_x_ = value;
}

bool hasBluePrimaryY() const {
  return true;
}
float bluePrimaryY() const {
  return member_blue_primary_y_;
}
void setBluePrimaryY(float value) {
  member_blue_primary_y_ = value;
}

bool hasGreenPrimaryX() const {
  return true;
}
float greenPrimaryX() const {
  return member_green_primary_x_;
}
void setGreenPrimaryX(float value) {
  member_green_primary_x_ = value;
}

bool hasGreenPrimaryY() const {
  return true;
}
float greenPrimaryY() const {
  return member_green_primary_y_;
}
void setGreenPrimaryY(float value) {
  member_green_primary_y_ = value;
}

bool hasMaximumLuminance() const {
  return true;
}
float maximumLuminance() const {
  return member_maximum_luminance_;
}
void setMaximumLuminance(float value) {
  member_maximum_luminance_ = value;
}

bool hasMinimumLuminance() const {
  return true;
}
float minimumLuminance() const {
  return member_minimum_luminance_;
}
void setMinimumLuminance(float value) {
  member_minimum_luminance_ = value;
}

bool hasRedPrimaryX() const {
  return true;
}
float redPrimaryX() const {
  return member_red_primary_x_;
}
void setRedPrimaryX(float value) {
  member_red_primary_x_ = value;
}

bool hasRedPrimaryY() const {
  return true;
}
float redPrimaryY() const {
  return member_red_primary_y_;
}
void setRedPrimaryY(float value) {
  member_red_primary_y_ = value;
}

bool hasWhitePointX() const {
  return true;
}
float whitePointX() const {
  return member_white_point_x_;
}
void setWhitePointX(float value) {
  member_white_point_x_ = value;
}

bool hasWhitePointY() const {
  return true;
}
float whitePointY() const {
  return member_white_point_y_;
}
void setWhitePointY(float value) {
  member_white_point_y_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 10;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



float member_blue_primary_x_;
float member_blue_primary_y_;
float member_green_primary_x_;
float member_green_primary_y_;
float member_maximum_luminance_;
float member_minimum_luminance_;
float member_red_primary_x_;
float member_red_primary_y_;
float member_white_point_x_;
float member_white_point_y_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CANVAS_SMPTE_ST_2086_METADATA_H_
