// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CANVAS_HIGH_DYNAMIC_RANGE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CANVAS_HIGH_DYNAMIC_RANGE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_canvas_high_dynamic_range_mode.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class CanvasSmpteSt2086Metadata;
class ExceptionState;

class CORE_EXPORT CanvasHighDynamicRangeOptions : public bindings::InputDictionaryBase {
  
  public:
static CanvasHighDynamicRangeOptions* Create() {
  return MakeGarbageCollected<CanvasHighDynamicRangeOptions>();
}
static CanvasHighDynamicRangeOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CanvasHighDynamicRangeOptions>(isolate);
}
static CanvasHighDynamicRangeOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CanvasHighDynamicRangeOptions();
explicit  CanvasHighDynamicRangeOptions(v8::Isolate* isolate);

bool hasAgtm() const {
  return has_agtm_;
}
const String& agtm() const {
  DCHECK(hasAgtm());
return member_agtm_;
}
String getAgtmOr(const String& fallback_value) const;
String getAgtmOr(String&& fallback_value) const;
void setAgtm(const String& value);
void setAgtm(String&& value);

bool hasMode() const {
  return true;
}
V8CanvasHighDynamicRangeMode mode() const {
  return member_mode_;
}
void setMode(V8CanvasHighDynamicRangeMode value) {
  member_mode_ = value;
}
void setMode(V8CanvasHighDynamicRangeMode::Enum value) {
  member_mode_ = V8CanvasHighDynamicRangeMode(value);
}

bool hasSmpteSt2086Metadata() const {
  return has_smpte_st_2086_metadata_;
}
CanvasSmpteSt2086Metadata* smpteSt2086Metadata() const {
  DCHECK(hasSmpteSt2086Metadata());
return member_smpte_st_2086_metadata_.Get();
}
CanvasSmpteSt2086Metadata* getSmpteSt2086MetadataOr(CanvasSmpteSt2086Metadata* fallback_value) const {
  if (!hasSmpteSt2086Metadata()) {
  return fallback_value;
}
return member_smpte_st_2086_metadata_.Get();
}
void setSmpteSt2086Metadata(CanvasSmpteSt2086Metadata* value) {
  member_smpte_st_2086_metadata_ = value;
has_smpte_st_2086_metadata_ = true;
DCHECK(member_smpte_st_2086_metadata_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_agtm_ = false;
bool has_smpte_st_2086_metadata_ = false;

String member_agtm_;
V8CanvasHighDynamicRangeMode member_mode_{V8CanvasHighDynamicRangeMode::Enum::kDefault};
Member<CanvasSmpteSt2086Metadata> member_smpte_st_2086_metadata_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CANVAS_HIGH_DYNAMIC_RANGE_OPTIONS_H_
