// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_BASELINES_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_BASELINES_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT Baselines : public bindings::DictionaryBase {
  
  public:
static Baselines* Create() {
  return MakeGarbageCollected<Baselines>();
}
static Baselines* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<Baselines>(isolate);
}
static Baselines* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  Baselines();
explicit  Baselines(v8::Isolate* isolate);

bool hasAlphabetic() const {
  return has_alphabetic_;
}
double alphabetic() const {
  DCHECK(hasAlphabetic());
return member_alphabetic_;
}
double getAlphabeticOr(double fallback_value) const {
  if (!hasAlphabetic()) {
  return fallback_value;
}
return member_alphabetic_;
}
void setAlphabetic(double value) {
  member_alphabetic_ = value;
has_alphabetic_ = true;
}

bool hasHanging() const {
  return has_hanging_;
}
double hanging() const {
  DCHECK(hasHanging());
return member_hanging_;
}
double getHangingOr(double fallback_value) const {
  if (!hasHanging()) {
  return fallback_value;
}
return member_hanging_;
}
void setHanging(double value) {
  member_hanging_ = value;
has_hanging_ = true;
}

bool hasIdeographic() const {
  return has_ideographic_;
}
double ideographic() const {
  DCHECK(hasIdeographic());
return member_ideographic_;
}
double getIdeographicOr(double fallback_value) const {
  if (!hasIdeographic()) {
  return fallback_value;
}
return member_ideographic_;
}
void setIdeographic(double value) {
  member_ideographic_ = value;
has_ideographic_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_alphabetic_ = false;
bool has_hanging_ = false;
bool has_ideographic_ = false;

double member_alphabetic_;
double member_hanging_;
double member_ideographic_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_BASELINES_H_
