// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_ACCELERATOR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_ACCELERATOR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT Accelerator : public bindings::InputDictionaryBase {
  
  public:
static Accelerator* Create() {
  return MakeGarbageCollected<Accelerator>();
}
static Accelerator* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<Accelerator>(isolate);
}
static Accelerator* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  Accelerator();
explicit  Accelerator(v8::Isolate* isolate);

bool hasKeyCode() const {
  return has_key_code_;
}
uint16_t keyCode() const {
  DCHECK(hasKeyCode());
return member_key_code_;
}
uint16_t getKeyCodeOr(uint16_t fallback_value) const {
  if (!hasKeyCode()) {
  return fallback_value;
}
return member_key_code_;
}
void setKeyCode(uint16_t value) {
  member_key_code_ = value;
has_key_code_ = true;
}

bool hasModifiers() const {
  return has_modifiers_;
}
int32_t modifiers() const {
  DCHECK(hasModifiers());
return member_modifiers_;
}
int32_t getModifiersOr(int32_t fallback_value) const {
  if (!hasModifiers()) {
  return fallback_value;
}
return member_modifiers_;
}
void setModifiers(int32_t value) {
  member_modifiers_ = value;
has_modifiers_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_key_code_ = false;
bool has_modifiers_ = false;

uint16_t member_key_code_;
int32_t member_modifiers_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_ACCELERATOR_H_
