// third_party/blink/public/mojom/worker/worklet_global_scope_creation_params.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  BrowserInterfaceBrokerRemote as blink_mojom_BrowserInterfaceBrokerRemote,
  BrowserInterfaceBrokerPendingReceiver as blink_mojom_BrowserInterfaceBrokerPendingReceiver
} from '../browser_interface_broker.mojom.m.js';

import {
  DevToolsAgentRemote as blink_mojom_DevToolsAgentRemote,
  DevToolsAgentPendingReceiver as blink_mojom_DevToolsAgentPendingReceiver,
  DevToolsAgentHostRemote as blink_mojom_DevToolsAgentHostRemote,
  DevToolsAgentHostPendingReceiver as blink_mojom_DevToolsAgentHostPendingReceiver
} from '../devtools/devtools_agent.mojom.m.js';

import {
  CodeCacheHostRemote as blink_mojom_CodeCacheHostRemote,
  CodeCacheHostPendingReceiver as blink_mojom_CodeCacheHostPendingReceiver
} from '../loader/code_cache.mojom.m.js';

import {
  OriginTrialFeature as blink_mojom_OriginTrialFeature,
  OriginTrialFeatureSpec as blink_mojom_OriginTrialFeatureSpec
} from '../origin_trials/origin_trial_feature.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WorkletDevToolsHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.WorkletDevToolsHost', scope);
  }
}

/** @interface */
export class WorkletDevToolsHostInterface {
  
  /**
   * @param { !blink_mojom_DevToolsAgentRemote } agent
   * @param { !blink_mojom_DevToolsAgentHostPendingReceiver } agentHost
   */

  onReadyForInspection(agent, agentHost) {}
}

/**
 * @implements { WorkletDevToolsHostInterface }
 */
export class WorkletDevToolsHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WorkletDevToolsHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WorkletDevToolsHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WorkletDevToolsHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_DevToolsAgentRemote } agent
   * @param { !blink_mojom_DevToolsAgentHostPendingReceiver } agentHost
   */

  onReadyForInspection(
      agent,
      agentHost) {
    this.proxy.sendMessage(
        0,
        WorkletDevToolsHost_OnReadyForInspection_ParamsSpec.$,
        null,
        [
          agent,
          agentHost
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WorkletDevToolsHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WorkletDevToolsHostReceiver {
  /**
   * @param {!WorkletDevToolsHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WorkletDevToolsHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WorkletDevToolsHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WorkletDevToolsHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WorkletDevToolsHost_OnReadyForInspection_ParamsSpec.$,
        null,
        impl.onReadyForInspection.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WorkletDevToolsHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WorkletDevToolsHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WorkletDevToolsHostRemote}
   */
  static getRemote() {
    let remote = new WorkletDevToolsHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WorkletDevToolsHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WorkletDevToolsHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WorkletDevToolsHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WorkletDevToolsHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReadyForInspection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WorkletDevToolsHost_OnReadyForInspection_ParamsSpec.$,
        null,
        this.onReadyForInspection.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WorkletGlobalScopeCreationParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WorkletDevToolsHost_OnReadyForInspection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    WorkletGlobalScopeCreationParamsSpec.$,
    'WorkletGlobalScopeCreationParams',
    [
      mojo.internal.StructField(
        'scriptUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'starterOrigin', 8,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'originTrialFeatures', 16,
        0,
        mojo.internal.Array(blink_mojom_OriginTrialFeatureSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'devtoolsToken', 24,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'devtoolsHost', 32,
        0,
        mojo.internal.InterfaceProxy(WorkletDevToolsHostRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'codeCacheHost', 40,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_CodeCacheHostRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'browserInterfaceBroker', 48,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_BrowserInterfaceBrokerRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'waitForDebugger', 56,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 72],]);



/**
 * @record
 */
export class WorkletGlobalScopeCreationParams {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.scriptUrl;
    /** @type { !url_mojom_Origin } */
    this.starterOrigin;
    /** @type { !Array<!blink_mojom_OriginTrialFeature> } */
    this.originTrialFeatures;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.devtoolsToken;
    /** @type { !WorkletDevToolsHostRemote } */
    this.devtoolsHost;
    /** @type { !blink_mojom_CodeCacheHostRemote } */
    this.codeCacheHost;
    /** @type { !blink_mojom_BrowserInterfaceBrokerRemote } */
    this.browserInterfaceBroker;
    /** @type { !boolean } */
    this.waitForDebugger;
  }
}



mojo.internal.Struct(
    WorkletDevToolsHost_OnReadyForInspection_ParamsSpec.$,
    'WorkletDevToolsHost_OnReadyForInspection_Params',
    [
      mojo.internal.StructField(
        'agent', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_DevToolsAgentRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'agentHost', 8,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_DevToolsAgentHostPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WorkletDevToolsHost_OnReadyForInspection_Params {
  constructor() {
    /** @type { !blink_mojom_DevToolsAgentRemote } */
    this.agent;
    /** @type { !blink_mojom_DevToolsAgentHostPendingReceiver } */
    this.agentHost;
  }
}

