// third_party/blink/public/mojom/worker/subresource_loader_updater.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  URLLoaderFactoryBundle as blink_mojom_URLLoaderFactoryBundle,
  URLLoaderFactoryBundleSpec as blink_mojom_URLLoaderFactoryBundleSpec
} from '../loader/url_loader_factory_bundle.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SubresourceLoaderUpdaterPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.SubresourceLoaderUpdater', scope);
  }
}

/** @interface */
export class SubresourceLoaderUpdaterInterface {
  
  /**
   * @param { !blink_mojom_URLLoaderFactoryBundle } subresourceLoaderFactories
   */

  updateSubresourceLoaderFactories(subresourceLoaderFactories) {}
}

/**
 * @implements { SubresourceLoaderUpdaterInterface }
 */
export class SubresourceLoaderUpdaterRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SubresourceLoaderUpdaterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SubresourceLoaderUpdaterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SubresourceLoaderUpdaterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_URLLoaderFactoryBundle } subresourceLoaderFactories
   */

  updateSubresourceLoaderFactories(
      subresourceLoaderFactories) {
    this.proxy.sendMessage(
        0,
        SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_ParamsSpec.$,
        null,
        [
          subresourceLoaderFactories
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SubresourceLoaderUpdater
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SubresourceLoaderUpdaterReceiver {
  /**
   * @param {!SubresourceLoaderUpdaterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SubresourceLoaderUpdaterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SubresourceLoaderUpdaterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SubresourceLoaderUpdaterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_ParamsSpec.$,
        null,
        impl.updateSubresourceLoaderFactories.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SubresourceLoaderUpdater {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SubresourceLoaderUpdater";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SubresourceLoaderUpdaterRemote}
   */
  static getRemote() {
    let remote = new SubresourceLoaderUpdaterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SubresourceLoaderUpdater
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SubresourceLoaderUpdaterCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SubresourceLoaderUpdaterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SubresourceLoaderUpdaterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateSubresourceLoaderFactories =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_ParamsSpec.$,
        null,
        this.updateSubresourceLoaderFactories.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_ParamsSpec.$,
    'SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Params',
    [
      mojo.internal.StructField(
        'subresourceLoaderFactories', 0,
        0,
        blink_mojom_URLLoaderFactoryBundleSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Params {
  constructor() {
    /** @type { !blink_mojom_URLLoaderFactoryBundle } */
    this.subresourceLoaderFactories;
  }
}

