// third_party/blink/public/mojom/worker/subresource_loader_updater.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/worker/subresource_loader_updater.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var url_loader_factory_bundle$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom', '../loader/url_loader_factory_bundle.mojom.js');
  }



  function SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Params.prototype.initDefaults_ = function() {
    this.subresourceLoaderFactories = null;
  };
  SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Params.subresourceLoaderFactories
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url_loader_factory_bundle$.URLLoaderFactoryBundle, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Params.encodedSize = codec.kStructHeaderSize + 8;

  SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Params.decode = function(decoder) {
    var packed;
    var val = new SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.subresourceLoaderFactories =
        decoder.decodeStructPointer(url_loader_factory_bundle$.URLLoaderFactoryBundle);
    return val;
  };

  SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url_loader_factory_bundle$.URLLoaderFactoryBundle, val.subresourceLoaderFactories);
  };
  var kSubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Name = 0;

  function SubresourceLoaderUpdaterPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SubresourceLoaderUpdater,
                                                   handleOrPtrInfo);
  }

  function SubresourceLoaderUpdaterAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SubresourceLoaderUpdater, associatedInterfacePtrInfo);
  }

  SubresourceLoaderUpdaterAssociatedPtr.prototype =
      Object.create(SubresourceLoaderUpdaterPtr.prototype);
  SubresourceLoaderUpdaterAssociatedPtr.prototype.constructor =
      SubresourceLoaderUpdaterAssociatedPtr;

  function SubresourceLoaderUpdaterProxy(receiver) {
    this.receiver_ = receiver;
  }
  SubresourceLoaderUpdaterPtr.prototype.updateSubresourceLoaderFactories = function() {
    return SubresourceLoaderUpdaterProxy.prototype.updateSubresourceLoaderFactories
        .apply(this.ptr.getProxy(), arguments);
  };

  SubresourceLoaderUpdaterProxy.prototype.updateSubresourceLoaderFactories = function(subresourceLoaderFactories) {
    var params_ = new SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Params();
    params_.subresourceLoaderFactories = subresourceLoaderFactories;
    var builder = new codec.MessageV0Builder(
        kSubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Name,
        codec.align(SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Params.encodedSize));
    builder.encodeStruct(SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SubresourceLoaderUpdaterStub(delegate) {
    this.delegate_ = delegate;
  }
  SubresourceLoaderUpdaterStub.prototype.updateSubresourceLoaderFactories = function(subresourceLoaderFactories) {
    return this.delegate_ && this.delegate_.updateSubresourceLoaderFactories && this.delegate_.updateSubresourceLoaderFactories(subresourceLoaderFactories);
  }

  SubresourceLoaderUpdaterStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Name:
      var params = reader.decodeStruct(SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Params);
      this.updateSubresourceLoaderFactories(params.subresourceLoaderFactories);
      return true;
    default:
      return false;
    }
  };

  SubresourceLoaderUpdaterStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSubresourceLoaderUpdaterRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSubresourceLoaderUpdaterResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SubresourceLoaderUpdater = {
    name: 'blink.mojom.SubresourceLoaderUpdater',
    kVersion: 0,
    ptrClass: SubresourceLoaderUpdaterPtr,
    proxyClass: SubresourceLoaderUpdaterProxy,
    stubClass: SubresourceLoaderUpdaterStub,
    validateRequest: validateSubresourceLoaderUpdaterRequest,
    validateResponse: null,
  };
  SubresourceLoaderUpdaterStub.prototype.validator = validateSubresourceLoaderUpdaterRequest;
  SubresourceLoaderUpdaterProxy.prototype.validator = null;
  exports.SubresourceLoaderUpdater = SubresourceLoaderUpdater;
  exports.SubresourceLoaderUpdaterPtr = SubresourceLoaderUpdaterPtr;
  exports.SubresourceLoaderUpdaterAssociatedPtr = SubresourceLoaderUpdaterAssociatedPtr;
})();