// third_party/blink/public/mojom/worker/shared_worker_host.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_HOST_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_HOST_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/worker/shared_worker_host.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/worker/shared_worker_host.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/worker/shared_worker_host.mojom-blink-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/use_counter/metrics/web_feature.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/worker/shared_worker_exception_details.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class SharedWorkerHostProxy;

template <typename ImplRefTraits>
class SharedWorkerHostStub;

class SharedWorkerHostRequestValidator;


class PLATFORM_EXPORT SharedWorkerHost
    : public SharedWorkerHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.SharedWorkerHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SharedWorkerHostInterfaceBase;
  using Proxy_ = SharedWorkerHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = SharedWorkerHostStub<ImplRefTraits>;

  using RequestValidator_ = SharedWorkerHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnConnectedMinVersion = 0,
    kOnContextClosedMinVersion = 0,
    kOnReadyForInspectionMinVersion = 0,
    kOnScriptLoadFailedMinVersion = 0,
    kOnReportExceptionMinVersion = 0,
    kOnFeatureUsedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnConnected_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnContextClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnReadyForInspection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnScriptLoadFailed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnReportException_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFeatureUsed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SharedWorkerHost() = default;

  virtual void OnConnected(int32_t connection_id) = 0;

  virtual void OnContextClosed() = 0;

  virtual void OnReadyForInspection(::mojo::PendingRemote<::blink::mojom::blink::DevToolsAgent> agent, ::mojo::PendingReceiver<::blink::mojom::blink::DevToolsAgentHost> agent_host) = 0;

  virtual void OnScriptLoadFailed(const ::blink::String& error_message) = 0;

  virtual void OnReportException(::blink::mojom::blink::SharedWorkerExceptionDetailsPtr details) = 0;

  virtual void OnFeatureUsed(::blink::mojom::blink::WebFeature feature) = 0;
};



class PLATFORM_EXPORT SharedWorkerHostProxy
    : public SharedWorkerHost {
 public:
  using InterfaceType = SharedWorkerHost;

  explicit SharedWorkerHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnConnected(int32_t connection_id) final;
  
  void OnContextClosed() final;
  
  void OnReadyForInspection(::mojo::PendingRemote<::blink::mojom::blink::DevToolsAgent> agent, ::mojo::PendingReceiver<::blink::mojom::blink::DevToolsAgentHost> agent_host) final;
  
  void OnScriptLoadFailed(const ::blink::String& error_message) final;
  
  void OnReportException(::blink::mojom::blink::SharedWorkerExceptionDetailsPtr details) final;
  
  void OnFeatureUsed(::blink::mojom::blink::WebFeature feature) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT SharedWorkerHostStubDispatch {
 public:
  static bool Accept(SharedWorkerHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SharedWorkerHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SharedWorkerHost>>
class SharedWorkerHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SharedWorkerHostStub() = default;
  ~SharedWorkerHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedWorkerHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedWorkerHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT SharedWorkerHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_HOST_MOJOM_BLINK_H_