// third_party/blink/public/mojom/worker/shared_worker_host.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/worker/shared_worker_host.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/worker/shared_worker_host.mojom-params-data.h"
#include "third_party/blink/public/mojom/worker/shared_worker_host.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/worker/shared_worker_host.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/worker/shared_worker_host.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

SharedWorkerHost::IPCStableHashFunction SharedWorkerHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SharedWorkerHost>(message.name())) {
    case messages::SharedWorkerHost::kOnConnected: {
      return &SharedWorkerHost::OnConnected_Sym::IPCStableHash;
    }
    case messages::SharedWorkerHost::kOnContextClosed: {
      return &SharedWorkerHost::OnContextClosed_Sym::IPCStableHash;
    }
    case messages::SharedWorkerHost::kOnReadyForInspection: {
      return &SharedWorkerHost::OnReadyForInspection_Sym::IPCStableHash;
    }
    case messages::SharedWorkerHost::kOnScriptLoadFailed: {
      return &SharedWorkerHost::OnScriptLoadFailed_Sym::IPCStableHash;
    }
    case messages::SharedWorkerHost::kOnReportException: {
      return &SharedWorkerHost::OnReportException_Sym::IPCStableHash;
    }
    case messages::SharedWorkerHost::kOnFeatureUsed: {
      return &SharedWorkerHost::OnFeatureUsed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SharedWorkerHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SharedWorkerHost>(message.name())) {
      case messages::SharedWorkerHost::kOnConnected:
            return "Receive blink::mojom::SharedWorkerHost::OnConnected";
      case messages::SharedWorkerHost::kOnContextClosed:
            return "Receive blink::mojom::SharedWorkerHost::OnContextClosed";
      case messages::SharedWorkerHost::kOnReadyForInspection:
            return "Receive blink::mojom::SharedWorkerHost::OnReadyForInspection";
      case messages::SharedWorkerHost::kOnScriptLoadFailed:
            return "Receive blink::mojom::SharedWorkerHost::OnScriptLoadFailed";
      case messages::SharedWorkerHost::kOnReportException:
            return "Receive blink::mojom::SharedWorkerHost::OnReportException";
      case messages::SharedWorkerHost::kOnFeatureUsed:
            return "Receive blink::mojom::SharedWorkerHost::OnFeatureUsed";
    }
  } else {
    switch (static_cast<messages::SharedWorkerHost>(message.name())) {
      case messages::SharedWorkerHost::kOnConnected:
            return "Receive reply blink::mojom::SharedWorkerHost::OnConnected";
      case messages::SharedWorkerHost::kOnContextClosed:
            return "Receive reply blink::mojom::SharedWorkerHost::OnContextClosed";
      case messages::SharedWorkerHost::kOnReadyForInspection:
            return "Receive reply blink::mojom::SharedWorkerHost::OnReadyForInspection";
      case messages::SharedWorkerHost::kOnScriptLoadFailed:
            return "Receive reply blink::mojom::SharedWorkerHost::OnScriptLoadFailed";
      case messages::SharedWorkerHost::kOnReportException:
            return "Receive reply blink::mojom::SharedWorkerHost::OnReportException";
      case messages::SharedWorkerHost::kOnFeatureUsed:
            return "Receive reply blink::mojom::SharedWorkerHost::OnFeatureUsed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SharedWorkerHost::OnConnected_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x00115e03;  // IPCStableHash for blink::mojom::SharedWorkerHost::OnConnected
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedWorkerHost::OnContextClosed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x19d82d52;  // IPCStableHash for blink::mojom::SharedWorkerHost::OnContextClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedWorkerHost::OnReadyForInspection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6e23a902;  // IPCStableHash for blink::mojom::SharedWorkerHost::OnReadyForInspection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedWorkerHost::OnScriptLoadFailed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2b360107;  // IPCStableHash for blink::mojom::SharedWorkerHost::OnScriptLoadFailed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedWorkerHost::OnReportException_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6fa01ce8;  // IPCStableHash for blink::mojom::SharedWorkerHost::OnReportException
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedWorkerHost::OnFeatureUsed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xea13fd36;  // IPCStableHash for blink::mojom::SharedWorkerHost::OnFeatureUsed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SharedWorkerHostProxy::SharedWorkerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SharedWorkerHostProxy::OnConnected(
    int32_t in_connection_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedWorkerHost::OnConnected", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("connection_id"), in_connection_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedWorkerHost::kOnConnected), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerHost_OnConnected_Params_Data> params(
          message);
  params.Allocate();

  params->connection_id = in_connection_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerHost::Name_);
  message.set_method_name("OnConnected");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SharedWorkerHostProxy::OnContextClosed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::SharedWorkerHost::OnContextClosed");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedWorkerHost::kOnContextClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerHost_OnContextClosed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerHost::Name_);
  message.set_method_name("OnContextClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SharedWorkerHostProxy::OnReadyForInspection(
    ::mojo::PendingRemote<::blink::mojom::blink::DevToolsAgent> in_agent, ::mojo::PendingReceiver<::blink::mojom::blink::DevToolsAgentHost> in_agent_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedWorkerHost::OnReadyForInspection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent"), in_agent,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::DevToolsAgent>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent_host"), in_agent_host,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::DevToolsAgentHost>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedWorkerHost::kOnReadyForInspection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerHost_OnReadyForInspection_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::DevToolsAgentInterfaceBase>>(
    in_agent,
    &params->agent,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->agent)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid agent in SharedWorkerHost.OnReadyForInspection request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::DevToolsAgentHostInterfaceBase>>(
    in_agent_host,
    &params->agent_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->agent_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid agent_host in SharedWorkerHost.OnReadyForInspection request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerHost::Name_);
  message.set_method_name("OnReadyForInspection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SharedWorkerHostProxy::OnScriptLoadFailed(
    const ::blink::String& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedWorkerHost::OnScriptLoadFailed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedWorkerHost::kOnScriptLoadFailed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerHost_OnScriptLoadFailed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_message,
    error_message_fragment);

  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error_message in SharedWorkerHost.OnScriptLoadFailed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerHost::Name_);
  message.set_method_name("OnScriptLoadFailed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SharedWorkerHostProxy::OnReportException(
    ::blink::mojom::blink::SharedWorkerExceptionDetailsPtr in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedWorkerHost::OnReportException", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type ::blink::mojom::blink::SharedWorkerExceptionDetailsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedWorkerHost::kOnReportException), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerHost_OnReportException_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::SharedWorkerExceptionDetailsDataView>(
    in_details,
    details_fragment);

  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->details.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null details in SharedWorkerHost.OnReportException request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerHost::Name_);
  message.set_method_name("OnReportException");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SharedWorkerHostProxy::OnFeatureUsed(
    ::blink::mojom::blink::WebFeature in_feature) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedWorkerHost::OnFeatureUsed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feature"), in_feature,
                        "<value of type ::blink::mojom::blink::WebFeature>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedWorkerHost::kOnFeatureUsed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerHost_OnFeatureUsed_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::WebFeature>(
    in_feature,
    &params->feature);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerHost::Name_);
  message.set_method_name("OnFeatureUsed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SharedWorkerHostStubDispatch::Accept(
    SharedWorkerHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SharedWorkerHost>(message->header()->name)) {
    case messages::SharedWorkerHost::kOnConnected: {
      DCHECK(message->is_serialized());
      internal::SharedWorkerHost_OnConnected_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerHost_OnConnected_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SharedWorkerHost.0
      bool success = true;
      int32_t p_connection_id{};
      SharedWorkerHost_OnConnected_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_connection_id = input_data_view.connection_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConnected(        
        std::move(p_connection_id));
      return true;
    }
    case messages::SharedWorkerHost::kOnContextClosed: {
      DCHECK(message->is_serialized());
      internal::SharedWorkerHost_OnContextClosed_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerHost_OnContextClosed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SharedWorkerHost.1
      bool success = true;
      SharedWorkerHost_OnContextClosed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnContextClosed(        );
      return true;
    }
    case messages::SharedWorkerHost::kOnReadyForInspection: {
      DCHECK(message->is_serialized());
      internal::SharedWorkerHost_OnReadyForInspection_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerHost_OnReadyForInspection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SharedWorkerHost.2
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::blink::DevToolsAgent> p_agent{};
      ::mojo::PendingReceiver<::blink::mojom::blink::DevToolsAgentHost> p_agent_host{};
      SharedWorkerHost_OnReadyForInspection_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_agent =
            input_data_view.TakeAgent<decltype(p_agent)>();
      }
      if (success) {
        p_agent_host =
            input_data_view.TakeAgentHost<decltype(p_agent_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReadyForInspection(        
        std::move(p_agent), 
        std::move(p_agent_host));
      return true;
    }
    case messages::SharedWorkerHost::kOnScriptLoadFailed: {
      DCHECK(message->is_serialized());
      internal::SharedWorkerHost_OnScriptLoadFailed_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerHost_OnScriptLoadFailed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SharedWorkerHost.3
      bool success = true;
      ::blink::String p_error_message{};
      SharedWorkerHost_OnScriptLoadFailed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadErrorMessage(&p_error_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScriptLoadFailed(        
        std::move(p_error_message));
      return true;
    }
    case messages::SharedWorkerHost::kOnReportException: {
      DCHECK(message->is_serialized());
      internal::SharedWorkerHost_OnReportException_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerHost_OnReportException_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SharedWorkerHost.4
      bool success = true;
      ::blink::mojom::blink::SharedWorkerExceptionDetailsPtr p_details{};
      SharedWorkerHost_OnReportException_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReportException(        
        std::move(p_details));
      return true;
    }
    case messages::SharedWorkerHost::kOnFeatureUsed: {
      DCHECK(message->is_serialized());
      internal::SharedWorkerHost_OnFeatureUsed_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerHost_OnFeatureUsed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SharedWorkerHost.5
      bool success = true;
      ::blink::mojom::blink::WebFeature p_feature{};
      SharedWorkerHost_OnFeatureUsed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeature(&p_feature))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFeatureUsed(        
        std::move(p_feature));
      return true;
    }
  }
  return false;
}

// static
bool SharedWorkerHostStubDispatch::AcceptWithResponder(
    SharedWorkerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SharedWorkerHost>(message->header()->name)) {
    case messages::SharedWorkerHost::kOnConnected: {
      break;
    }
    case messages::SharedWorkerHost::kOnContextClosed: {
      break;
    }
    case messages::SharedWorkerHost::kOnReadyForInspection: {
      break;
    }
    case messages::SharedWorkerHost::kOnScriptLoadFailed: {
      break;
    }
    case messages::SharedWorkerHost::kOnReportException: {
      break;
    }
    case messages::SharedWorkerHost::kOnFeatureUsed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSharedWorkerHostValidationInfo[] = {
    { &internal::SharedWorkerHost_OnConnected_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SharedWorkerHost_OnContextClosed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SharedWorkerHost_OnReadyForInspection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SharedWorkerHost_OnScriptLoadFailed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SharedWorkerHost_OnReportException_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SharedWorkerHost_OnFeatureUsed_Params_Data::Validate,
     nullptr /* no response */},
};

bool SharedWorkerHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::SharedWorkerHost::Name_,
    kSharedWorkerHostValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void SharedWorkerHostInterceptorForTesting::OnConnected(int32_t connection_id) {
  GetForwardingInterface()->OnConnected(
    std::move(connection_id)
    );
}
void SharedWorkerHostInterceptorForTesting::OnContextClosed() {
  GetForwardingInterface()->OnContextClosed();
}
void SharedWorkerHostInterceptorForTesting::OnReadyForInspection(::mojo::PendingRemote<::blink::mojom::blink::DevToolsAgent> agent, ::mojo::PendingReceiver<::blink::mojom::blink::DevToolsAgentHost> agent_host) {
  GetForwardingInterface()->OnReadyForInspection(
    std::move(agent)
    , 
    std::move(agent_host)
    );
}
void SharedWorkerHostInterceptorForTesting::OnScriptLoadFailed(const ::blink::String& error_message) {
  GetForwardingInterface()->OnScriptLoadFailed(
    std::move(error_message)
    );
}
void SharedWorkerHostInterceptorForTesting::OnReportException(::blink::mojom::blink::SharedWorkerExceptionDetailsPtr details) {
  GetForwardingInterface()->OnReportException(
    std::move(details)
    );
}
void SharedWorkerHostInterceptorForTesting::OnFeatureUsed(::blink::mojom::blink::WebFeature feature) {
  GetForwardingInterface()->OnFeatureUsed(
    std::move(feature)
    );
}
SharedWorkerHostAsyncWaiter::SharedWorkerHostAsyncWaiter(
    SharedWorkerHost* proxy) : proxy_(proxy) {}

SharedWorkerHostAsyncWaiter::~SharedWorkerHostAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif