// third_party/blink/public/mojom/worker/shared_worker_factory.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/worker/shared_worker_factory.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/worker/shared_worker_factory.mojom-params-data.h"
#include "third_party/blink/public/mojom/worker/shared_worker_factory.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/worker/shared_worker_factory.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/worker/shared_worker_factory.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "third_party/blink/public/common/service_worker/service_worker_embedded_worker_status_mojom_traits.h"
#include "third_party/blink/public/common/service_worker/service_worker_router_rule_mojom_traits.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

SharedWorkerFactory::IPCStableHashFunction SharedWorkerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SharedWorkerFactory>(message.name())) {
    case messages::SharedWorkerFactory::kCreateSharedWorker: {
      return &SharedWorkerFactory::CreateSharedWorker_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SharedWorkerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SharedWorkerFactory>(message.name())) {
      case messages::SharedWorkerFactory::kCreateSharedWorker:
            return "Receive blink::mojom::SharedWorkerFactory::CreateSharedWorker";
    }
  } else {
    switch (static_cast<messages::SharedWorkerFactory>(message.name())) {
      case messages::SharedWorkerFactory::kCreateSharedWorker:
            return "Receive reply blink::mojom::SharedWorkerFactory::CreateSharedWorker";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SharedWorkerFactory::CreateSharedWorker_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0c6d01b2;  // IPCStableHash for blink::mojom::SharedWorkerFactory::CreateSharedWorker
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SharedWorkerFactoryProxy::SharedWorkerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SharedWorkerFactoryProxy::CreateSharedWorker(
    ::blink::mojom::blink::SharedWorkerInfoPtr in_info, const ::blink::SharedWorkerToken& in_token, const ::blink::BlinkStorageKey& in_constructor_key, const ::scoped_refptr<const ::blink::SecurityOrigin>& in_origin, bool in_is_constructor_secure_context, const ::blink::String& in_user_agent, ::blink::mojom::blink::UserAgentMetadataPtr in_ua_metadata, bool in_pause_on_start, const ::base::UnguessableToken& in_devtools_worker_token, const ::blink::RendererPreferences& in_renderer_preferences, ::mojo::PendingReceiver<::blink::mojom::blink::RendererPreferenceWatcher> in_preference_watcher_receiver, ::mojo::PendingRemote<::blink::mojom::blink::WorkerContentSettingsProxy> in_content_settings, ::blink::mojom::blink::ServiceWorkerContainerInfoForClientPtr in_service_worker_container_info, ::blink::mojom::blink::WorkerMainScriptLoadParamsPtr in_main_script_load_params, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> in_subresource_loader_factories, ::blink::mojom::blink::ControllerServiceWorkerInfoPtr in_controller_info, ::blink::mojom::blink::PolicyContainerPtr in_policy_container, ::mojo::PendingRemote<::blink::mojom::blink::SharedWorkerHost> in_host, ::mojo::PendingReceiver<::blink::mojom::blink::SharedWorker> in_shared_worker, ::mojo::PendingRemote<::blink::mojom::blink::BrowserInterfaceBroker> in_browser_interface_broker, int64_t in_ukm_source_id, bool in_require_cross_site_request_for_cookies, ::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver> in_coep_reporting_observer_receiver, ::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver> in_dip_reporting_observer_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedWorkerFactory::CreateSharedWorker", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type ::blink::mojom::blink::SharedWorkerInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::blink::SharedWorkerToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("constructor_key"), in_constructor_key,
                        "<value of type const ::blink::BlinkStorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_constructor_secure_context"), in_is_constructor_secure_context,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_agent"), in_user_agent,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ua_metadata"), in_ua_metadata,
                        "<value of type ::blink::mojom::blink::UserAgentMetadataPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pause_on_start"), in_pause_on_start,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtools_worker_token"), in_devtools_worker_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("renderer_preferences"), in_renderer_preferences,
                        "<value of type const ::blink::RendererPreferences&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preference_watcher_receiver"), in_preference_watcher_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::RendererPreferenceWatcher>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_settings"), in_content_settings,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::WorkerContentSettingsProxy>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_container_info"), in_service_worker_container_info,
                        "<value of type ::blink::mojom::blink::ServiceWorkerContainerInfoForClientPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("main_script_load_params"), in_main_script_load_params,
                        "<value of type ::blink::mojom::blink::WorkerMainScriptLoadParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subresource_loader_factories"), in_subresource_loader_factories,
                        "<value of type ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("controller_info"), in_controller_info,
                        "<value of type ::blink::mojom::blink::ControllerServiceWorkerInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_container"), in_policy_container,
                        "<value of type ::blink::mojom::blink::PolicyContainerPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::SharedWorkerHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_worker"), in_shared_worker,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::SharedWorker>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_interface_broker"), in_browser_interface_broker,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::BrowserInterfaceBroker>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ukm_source_id"), in_ukm_source_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("require_cross_site_request_for_cookies"), in_require_cross_site_request_for_cookies,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("coep_reporting_observer_receiver"), in_coep_reporting_observer_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dip_reporting_observer_receiver"), in_dip_reporting_observer_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedWorkerFactory::kCreateSharedWorker), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerFactory_CreateSharedWorker_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::SharedWorkerInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in SharedWorkerFactory.CreateSharedWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::SharedWorkerTokenDataView>(
    in_token,
    token_fragment);

  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null token in SharedWorkerFactory.CreateSharedWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->constructor_key)::BaseType> constructor_key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_constructor_key,
    constructor_key_fragment);

  params->constructor_key.Set(
      constructor_key_fragment.is_null() ? nullptr : constructor_key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->constructor_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null constructor_key in SharedWorkerFactory.CreateSharedWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_origin,
    origin_fragment);

  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin in SharedWorkerFactory.CreateSharedWorker request");

  params->is_constructor_secure_context = in_is_constructor_secure_context;
  mojo::internal::MessageFragment<
      typename decltype(params->user_agent)::BaseType> user_agent_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_user_agent,
    user_agent_fragment);

  params->user_agent.Set(
      user_agent_fragment.is_null() ? nullptr : user_agent_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->user_agent.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null user_agent in SharedWorkerFactory.CreateSharedWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->ua_metadata)::BaseType> ua_metadata_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::UserAgentMetadataDataView>(
    in_ua_metadata,
    ua_metadata_fragment);

  params->ua_metadata.Set(
      ua_metadata_fragment.is_null() ? nullptr : ua_metadata_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ua_metadata.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ua_metadata in SharedWorkerFactory.CreateSharedWorker request");

  params->pause_on_start = in_pause_on_start;
  mojo::internal::MessageFragment<
      typename decltype(params->devtools_worker_token)::BaseType> devtools_worker_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_devtools_worker_token,
    devtools_worker_token_fragment);

  params->devtools_worker_token.Set(
      devtools_worker_token_fragment.is_null() ? nullptr : devtools_worker_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devtools_worker_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devtools_worker_token in SharedWorkerFactory.CreateSharedWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->renderer_preferences)::BaseType> renderer_preferences_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RendererPreferencesDataView>(
    in_renderer_preferences,
    renderer_preferences_fragment);

  params->renderer_preferences.Set(
      renderer_preferences_fragment.is_null() ? nullptr : renderer_preferences_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->renderer_preferences.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null renderer_preferences in SharedWorkerFactory.CreateSharedWorker request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::RendererPreferenceWatcherInterfaceBase>>(
    in_preference_watcher_receiver,
    &params->preference_watcher_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->preference_watcher_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid preference_watcher_receiver in SharedWorkerFactory.CreateSharedWorker request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::WorkerContentSettingsProxyInterfaceBase>>(
    in_content_settings,
    &params->content_settings,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->content_settings)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid content_settings in SharedWorkerFactory.CreateSharedWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_worker_container_info)::BaseType> service_worker_container_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerContainerInfoForClientDataView>(
    in_service_worker_container_info,
    service_worker_container_info_fragment);

  params->service_worker_container_info.Set(
      service_worker_container_info_fragment.is_null() ? nullptr : service_worker_container_info_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->main_script_load_params)::BaseType> main_script_load_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::WorkerMainScriptLoadParamsDataView>(
    in_main_script_load_params,
    main_script_load_params_fragment);

  params->main_script_load_params.Set(
      main_script_load_params_fragment.is_null() ? nullptr : main_script_load_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->main_script_load_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null main_script_load_params in SharedWorkerFactory.CreateSharedWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->subresource_loader_factories)::BaseType> subresource_loader_factories_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
    in_subresource_loader_factories,
    subresource_loader_factories_fragment);

  params->subresource_loader_factories.Set(
      subresource_loader_factories_fragment.is_null() ? nullptr : subresource_loader_factories_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->subresource_loader_factories.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null subresource_loader_factories in SharedWorkerFactory.CreateSharedWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->controller_info)::BaseType> controller_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ControllerServiceWorkerInfoDataView>(
    in_controller_info,
    controller_info_fragment);

  params->controller_info.Set(
      controller_info_fragment.is_null() ? nullptr : controller_info_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->policy_container)::BaseType> policy_container_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PolicyContainerDataView>(
    in_policy_container,
    policy_container_fragment);

  params->policy_container.Set(
      policy_container_fragment.is_null() ? nullptr : policy_container_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->policy_container.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null policy_container in SharedWorkerFactory.CreateSharedWorker request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::SharedWorkerHostInterfaceBase>>(
    in_host,
    &params->host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid host in SharedWorkerFactory.CreateSharedWorker request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::SharedWorkerInterfaceBase>>(
    in_shared_worker,
    &params->shared_worker,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->shared_worker)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid shared_worker in SharedWorkerFactory.CreateSharedWorker request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
    in_browser_interface_broker,
    &params->browser_interface_broker,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->browser_interface_broker)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid browser_interface_broker in SharedWorkerFactory.CreateSharedWorker request");

  params->ukm_source_id = in_ukm_source_id;

  params->require_cross_site_request_for_cookies = in_require_cross_site_request_for_cookies;

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ReportingObserverInterfaceBase>>(
    in_coep_reporting_observer_receiver,
    &params->coep_reporting_observer_receiver,
    &params.message());

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ReportingObserverInterfaceBase>>(
    in_dip_reporting_observer_receiver,
    &params->dip_reporting_observer_receiver,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerFactory::Name_);
  message.set_method_name("CreateSharedWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SharedWorkerFactoryStubDispatch::Accept(
    SharedWorkerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SharedWorkerFactory>(message->header()->name)) {
    case messages::SharedWorkerFactory::kCreateSharedWorker: {
      DCHECK(message->is_serialized());
      internal::SharedWorkerFactory_CreateSharedWorker_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerFactory_CreateSharedWorker_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SharedWorkerFactory.0
      bool success = true;
      ::blink::mojom::blink::SharedWorkerInfoPtr p_info{};
      ::blink::SharedWorkerToken p_token{};
      ::blink::BlinkStorageKey p_constructor_key{};
      ::scoped_refptr<const ::blink::SecurityOrigin> p_origin{};
      bool p_is_constructor_secure_context{};
      ::blink::String p_user_agent{};
      ::blink::mojom::blink::UserAgentMetadataPtr p_ua_metadata{};
      bool p_pause_on_start{};
      ::base::UnguessableToken p_devtools_worker_token{};
      ::blink::RendererPreferences p_renderer_preferences{};
      ::mojo::PendingReceiver<::blink::mojom::blink::RendererPreferenceWatcher> p_preference_watcher_receiver{};
      ::mojo::PendingRemote<::blink::mojom::blink::WorkerContentSettingsProxy> p_content_settings{};
      ::blink::mojom::blink::ServiceWorkerContainerInfoForClientPtr p_service_worker_container_info{};
      ::blink::mojom::blink::WorkerMainScriptLoadParamsPtr p_main_script_load_params{};
      ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> p_subresource_loader_factories{};
      ::blink::mojom::blink::ControllerServiceWorkerInfoPtr p_controller_info{};
      ::blink::mojom::blink::PolicyContainerPtr p_policy_container{};
      ::mojo::PendingRemote<::blink::mojom::blink::SharedWorkerHost> p_host{};
      ::mojo::PendingReceiver<::blink::mojom::blink::SharedWorker> p_shared_worker{};
      ::mojo::PendingRemote<::blink::mojom::blink::BrowserInterfaceBroker> p_browser_interface_broker{};
      int64_t p_ukm_source_id{};
      bool p_require_cross_site_request_for_cookies{};
      ::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver> p_coep_reporting_observer_receiver{};
      ::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver> p_dip_reporting_observer_receiver{};
      SharedWorkerFactory_CreateSharedWorker_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success && !input_data_view.ReadConstructorKey(&p_constructor_key))
        success = false;
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success)
        p_is_constructor_secure_context = input_data_view.is_constructor_secure_context();
      if (success && !input_data_view.ReadUserAgent(&p_user_agent))
        success = false;
      if (success && !input_data_view.ReadUaMetadata(&p_ua_metadata))
        success = false;
      if (success)
        p_pause_on_start = input_data_view.pause_on_start();
      if (success && !input_data_view.ReadDevtoolsWorkerToken(&p_devtools_worker_token))
        success = false;
      if (success && !input_data_view.ReadRendererPreferences(&p_renderer_preferences))
        success = false;
      if (success) {
        p_preference_watcher_receiver =
            input_data_view.TakePreferenceWatcherReceiver<decltype(p_preference_watcher_receiver)>();
      }
      if (success) {
        p_content_settings =
            input_data_view.TakeContentSettings<decltype(p_content_settings)>();
      }
      if (success && !input_data_view.ReadServiceWorkerContainerInfo(&p_service_worker_container_info))
        success = false;
      if (success && !input_data_view.ReadMainScriptLoadParams(&p_main_script_load_params))
        success = false;
      if (success && !input_data_view.ReadSubresourceLoaderFactories(&p_subresource_loader_factories))
        success = false;
      if (success && !input_data_view.ReadControllerInfo(&p_controller_info))
        success = false;
      if (success && !input_data_view.ReadPolicyContainer(&p_policy_container))
        success = false;
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (success) {
        p_shared_worker =
            input_data_view.TakeSharedWorker<decltype(p_shared_worker)>();
      }
      if (success) {
        p_browser_interface_broker =
            input_data_view.TakeBrowserInterfaceBroker<decltype(p_browser_interface_broker)>();
      }
      if (success)
        p_ukm_source_id = input_data_view.ukm_source_id();
      if (success)
        p_require_cross_site_request_for_cookies = input_data_view.require_cross_site_request_for_cookies();
      if (success) {
        p_coep_reporting_observer_receiver =
            input_data_view.TakeCoepReportingObserverReceiver<decltype(p_coep_reporting_observer_receiver)>();
      }
      if (success) {
        p_dip_reporting_observer_receiver =
            input_data_view.TakeDipReportingObserverReceiver<decltype(p_dip_reporting_observer_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateSharedWorker(        
        std::move(p_info), 
        std::move(p_token), 
        std::move(p_constructor_key), 
        std::move(p_origin), 
        std::move(p_is_constructor_secure_context), 
        std::move(p_user_agent), 
        std::move(p_ua_metadata), 
        std::move(p_pause_on_start), 
        std::move(p_devtools_worker_token), 
        std::move(p_renderer_preferences), 
        std::move(p_preference_watcher_receiver), 
        std::move(p_content_settings), 
        std::move(p_service_worker_container_info), 
        std::move(p_main_script_load_params), 
        std::move(p_subresource_loader_factories), 
        std::move(p_controller_info), 
        std::move(p_policy_container), 
        std::move(p_host), 
        std::move(p_shared_worker), 
        std::move(p_browser_interface_broker), 
        std::move(p_ukm_source_id), 
        std::move(p_require_cross_site_request_for_cookies), 
        std::move(p_coep_reporting_observer_receiver), 
        std::move(p_dip_reporting_observer_receiver));
      return true;
    }
  }
  return false;
}

// static
bool SharedWorkerFactoryStubDispatch::AcceptWithResponder(
    SharedWorkerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SharedWorkerFactory>(message->header()->name)) {
    case messages::SharedWorkerFactory::kCreateSharedWorker: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSharedWorkerFactoryValidationInfo[] = {
    { &internal::SharedWorkerFactory_CreateSharedWorker_Params_Data::Validate,
     nullptr /* no response */},
};

bool SharedWorkerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::SharedWorkerFactory::Name_,
    kSharedWorkerFactoryValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void SharedWorkerFactoryInterceptorForTesting::CreateSharedWorker(::blink::mojom::blink::SharedWorkerInfoPtr info, const ::blink::SharedWorkerToken& token, const ::blink::BlinkStorageKey& constructor_key, const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, bool is_constructor_secure_context, const ::blink::String& user_agent, ::blink::mojom::blink::UserAgentMetadataPtr ua_metadata, bool pause_on_start, const ::base::UnguessableToken& devtools_worker_token, const ::blink::RendererPreferences& renderer_preferences, ::mojo::PendingReceiver<::blink::mojom::blink::RendererPreferenceWatcher> preference_watcher_receiver, ::mojo::PendingRemote<::blink::mojom::blink::WorkerContentSettingsProxy> content_settings, ::blink::mojom::blink::ServiceWorkerContainerInfoForClientPtr service_worker_container_info, ::blink::mojom::blink::WorkerMainScriptLoadParamsPtr main_script_load_params, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories, ::blink::mojom::blink::ControllerServiceWorkerInfoPtr controller_info, ::blink::mojom::blink::PolicyContainerPtr policy_container, ::mojo::PendingRemote<::blink::mojom::blink::SharedWorkerHost> host, ::mojo::PendingReceiver<::blink::mojom::blink::SharedWorker> shared_worker, ::mojo::PendingRemote<::blink::mojom::blink::BrowserInterfaceBroker> browser_interface_broker, int64_t ukm_source_id, bool require_cross_site_request_for_cookies, ::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver> coep_reporting_observer_receiver, ::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver> dip_reporting_observer_receiver) {
  GetForwardingInterface()->CreateSharedWorker(
    std::move(info)
    , 
    std::move(token)
    , 
    std::move(constructor_key)
    , 
    std::move(origin)
    , 
    std::move(is_constructor_secure_context)
    , 
    std::move(user_agent)
    , 
    std::move(ua_metadata)
    , 
    std::move(pause_on_start)
    , 
    std::move(devtools_worker_token)
    , 
    std::move(renderer_preferences)
    , 
    std::move(preference_watcher_receiver)
    , 
    std::move(content_settings)
    , 
    std::move(service_worker_container_info)
    , 
    std::move(main_script_load_params)
    , 
    std::move(subresource_loader_factories)
    , 
    std::move(controller_info)
    , 
    std::move(policy_container)
    , 
    std::move(host)
    , 
    std::move(shared_worker)
    , 
    std::move(browser_interface_broker)
    , 
    std::move(ukm_source_id)
    , 
    std::move(require_cross_site_request_for_cookies)
    , 
    std::move(coep_reporting_observer_receiver)
    , 
    std::move(dip_reporting_observer_receiver)
    );
}
SharedWorkerFactoryAsyncWaiter::SharedWorkerFactoryAsyncWaiter(
    SharedWorkerFactory* proxy) : proxy_(proxy) {}

SharedWorkerFactoryAsyncWaiter::~SharedWorkerFactoryAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif