// third_party/blink/public/mojom/widget/visual_properties.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_VISUAL_PROPERTIES_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_VISUAL_PROPERTIES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/widget/visual_properties.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/widget/visual_properties.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/widget/visual_properties.mojom-blink-forward.h"  // IWYU pragma: export
#include "cc/mojom/browser_controls_params.mojom-blink.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-blink.h"
#include "third_party/blink/public/mojom/manifest/display_mode.mojom-blink-forward.h"
#include "ui/display/mojom/screen_infos.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/base/mojom/window_show_state.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/common/widget/visual_properties_mojom_traits.h"
#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {








class PLATFORM_EXPORT VisualProperties {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VisualProperties, T>::value>;
  using DataView = VisualPropertiesDataView;
  using Data_ = internal::VisualProperties_Data;

  template <typename... Args>
  static VisualPropertiesPtr New(Args&&... args) {
    return VisualPropertiesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VisualPropertiesPtr From(const U& u) {
    return mojo::TypeConverter<VisualPropertiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VisualProperties>::Convert(*this);
  }


  VisualProperties();

  VisualProperties(
      const ::display::ScreenInfos& screen_infos,
      bool auto_resize_enabled,
      bool resizable,
      const ::gfx::Size& min_size_for_auto_resize,
      const ::gfx::Size& max_size_for_auto_resize,
      const ::gfx::Size& new_size_device_px,
      const ::gfx::Size& visible_viewport_size_device_px,
      const ::gfx::Rect& compositor_viewport_pixel_rect,
      const ::cc::BrowserControlsParams& browser_controls_params,
      bool scroll_focused_node_into_view,
      const std::optional<::viz::LocalSurfaceId>& local_surface_id,
      bool is_fullscreen_granted,
      ::blink::mojom::blink::DisplayMode display_mode,
      ::ui::mojom::blink::WindowShowState window_show_state,
      uint32_t capture_sequence_number,
      double zoom_level,
      double css_zoom_factor,
      float page_scale_factor,
      float compositing_scale_factor,
      float cursor_accessibility_scale_factor,
      ::blink::Vector<::gfx::Rect> root_widget_viewport_segments,
      bool is_pinch_gesture_active,
      const ::gfx::Rect& window_controls_overlay_rect,
      uint32_t virtual_keyboard_resize_height_device_px);


  ~VisualProperties();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VisualPropertiesPtr>
  VisualPropertiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VisualProperties::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VisualProperties::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VisualProperties::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VisualProperties::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VisualProperties::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VisualProperties::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VisualProperties_UnserializedMessageContext<
            UserType, VisualProperties::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VisualProperties::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VisualProperties::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VisualProperties_UnserializedMessageContext<
            UserType, VisualProperties::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VisualProperties::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::display::ScreenInfos screen_infos;
  
  bool auto_resize_enabled;
  
  bool resizable;
  
  ::gfx::Size min_size_for_auto_resize;
  
  ::gfx::Size max_size_for_auto_resize;
  
  ::gfx::Size new_size_device_px;
  
  ::gfx::Size visible_viewport_size_device_px;
  
  ::gfx::Rect compositor_viewport_pixel_rect;
  
  ::cc::BrowserControlsParams browser_controls_params;
  
  bool scroll_focused_node_into_view;
  
  std::optional<::viz::LocalSurfaceId> local_surface_id;
  
  bool is_fullscreen_granted;
  
  ::blink::mojom::blink::DisplayMode display_mode;
  
  ::ui::mojom::blink::WindowShowState window_show_state;
  
  uint32_t capture_sequence_number;
  
  double zoom_level;
  
  double css_zoom_factor;
  
  float page_scale_factor;
  
  float compositing_scale_factor;
  
  float cursor_accessibility_scale_factor;
  
  ::blink::Vector<::gfx::Rect> root_widget_viewport_segments;
  
  bool is_pinch_gesture_active;
  
  ::gfx::Rect window_controls_overlay_rect;
  
  uint32_t virtual_keyboard_resize_height_device_px;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VisualProperties::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VisualProperties::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VisualProperties::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VisualProperties::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
VisualPropertiesPtr VisualProperties::Clone() const {
  return New(
      mojo::Clone(screen_infos),
      mojo::Clone(auto_resize_enabled),
      mojo::Clone(resizable),
      mojo::Clone(min_size_for_auto_resize),
      mojo::Clone(max_size_for_auto_resize),
      mojo::Clone(new_size_device_px),
      mojo::Clone(visible_viewport_size_device_px),
      mojo::Clone(compositor_viewport_pixel_rect),
      mojo::Clone(browser_controls_params),
      mojo::Clone(scroll_focused_node_into_view),
      mojo::Clone(local_surface_id),
      mojo::Clone(is_fullscreen_granted),
      mojo::Clone(display_mode),
      mojo::Clone(window_show_state),
      mojo::Clone(capture_sequence_number),
      mojo::Clone(zoom_level),
      mojo::Clone(css_zoom_factor),
      mojo::Clone(page_scale_factor),
      mojo::Clone(compositing_scale_factor),
      mojo::Clone(cursor_accessibility_scale_factor),
      mojo::Clone(root_widget_viewport_segments),
      mojo::Clone(is_pinch_gesture_active),
      mojo::Clone(window_controls_overlay_rect),
      mojo::Clone(virtual_keyboard_resize_height_device_px)
  );
}

template <typename T, VisualProperties::EnableIfSame<T>*>
bool VisualProperties::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->screen_infos, other_struct.screen_infos))
    return false;
  if (!mojo::Equals(this->auto_resize_enabled, other_struct.auto_resize_enabled))
    return false;
  if (!mojo::Equals(this->resizable, other_struct.resizable))
    return false;
  if (!mojo::Equals(this->min_size_for_auto_resize, other_struct.min_size_for_auto_resize))
    return false;
  if (!mojo::Equals(this->max_size_for_auto_resize, other_struct.max_size_for_auto_resize))
    return false;
  if (!mojo::Equals(this->new_size_device_px, other_struct.new_size_device_px))
    return false;
  if (!mojo::Equals(this->visible_viewport_size_device_px, other_struct.visible_viewport_size_device_px))
    return false;
  if (!mojo::Equals(this->compositor_viewport_pixel_rect, other_struct.compositor_viewport_pixel_rect))
    return false;
  if (!mojo::Equals(this->browser_controls_params, other_struct.browser_controls_params))
    return false;
  if (!mojo::Equals(this->scroll_focused_node_into_view, other_struct.scroll_focused_node_into_view))
    return false;
  if (!mojo::Equals(this->local_surface_id, other_struct.local_surface_id))
    return false;
  if (!mojo::Equals(this->is_fullscreen_granted, other_struct.is_fullscreen_granted))
    return false;
  if (!mojo::Equals(this->display_mode, other_struct.display_mode))
    return false;
  if (!mojo::Equals(this->window_show_state, other_struct.window_show_state))
    return false;
  if (!mojo::Equals(this->capture_sequence_number, other_struct.capture_sequence_number))
    return false;
  if (!mojo::Equals(this->zoom_level, other_struct.zoom_level))
    return false;
  if (!mojo::Equals(this->css_zoom_factor, other_struct.css_zoom_factor))
    return false;
  if (!mojo::Equals(this->page_scale_factor, other_struct.page_scale_factor))
    return false;
  if (!mojo::Equals(this->compositing_scale_factor, other_struct.compositing_scale_factor))
    return false;
  if (!mojo::Equals(this->cursor_accessibility_scale_factor, other_struct.cursor_accessibility_scale_factor))
    return false;
  if (!mojo::Equals(this->root_widget_viewport_segments, other_struct.root_widget_viewport_segments))
    return false;
  if (!mojo::Equals(this->is_pinch_gesture_active, other_struct.is_pinch_gesture_active))
    return false;
  if (!mojo::Equals(this->window_controls_overlay_rect, other_struct.window_controls_overlay_rect))
    return false;
  if (!mojo::Equals(this->virtual_keyboard_resize_height_device_px, other_struct.virtual_keyboard_resize_height_device_px))
    return false;
  return true;
}

template <typename T, VisualProperties::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.screen_infos < rhs.screen_infos)
    return true;
  if (rhs.screen_infos < lhs.screen_infos)
    return false;
  if (lhs.auto_resize_enabled < rhs.auto_resize_enabled)
    return true;
  if (rhs.auto_resize_enabled < lhs.auto_resize_enabled)
    return false;
  if (lhs.resizable < rhs.resizable)
    return true;
  if (rhs.resizable < lhs.resizable)
    return false;
  if (lhs.min_size_for_auto_resize < rhs.min_size_for_auto_resize)
    return true;
  if (rhs.min_size_for_auto_resize < lhs.min_size_for_auto_resize)
    return false;
  if (lhs.max_size_for_auto_resize < rhs.max_size_for_auto_resize)
    return true;
  if (rhs.max_size_for_auto_resize < lhs.max_size_for_auto_resize)
    return false;
  if (lhs.new_size_device_px < rhs.new_size_device_px)
    return true;
  if (rhs.new_size_device_px < lhs.new_size_device_px)
    return false;
  if (lhs.visible_viewport_size_device_px < rhs.visible_viewport_size_device_px)
    return true;
  if (rhs.visible_viewport_size_device_px < lhs.visible_viewport_size_device_px)
    return false;
  if (lhs.compositor_viewport_pixel_rect < rhs.compositor_viewport_pixel_rect)
    return true;
  if (rhs.compositor_viewport_pixel_rect < lhs.compositor_viewport_pixel_rect)
    return false;
  if (lhs.browser_controls_params < rhs.browser_controls_params)
    return true;
  if (rhs.browser_controls_params < lhs.browser_controls_params)
    return false;
  if (lhs.scroll_focused_node_into_view < rhs.scroll_focused_node_into_view)
    return true;
  if (rhs.scroll_focused_node_into_view < lhs.scroll_focused_node_into_view)
    return false;
  if (lhs.local_surface_id < rhs.local_surface_id)
    return true;
  if (rhs.local_surface_id < lhs.local_surface_id)
    return false;
  if (lhs.is_fullscreen_granted < rhs.is_fullscreen_granted)
    return true;
  if (rhs.is_fullscreen_granted < lhs.is_fullscreen_granted)
    return false;
  if (lhs.display_mode < rhs.display_mode)
    return true;
  if (rhs.display_mode < lhs.display_mode)
    return false;
  if (lhs.window_show_state < rhs.window_show_state)
    return true;
  if (rhs.window_show_state < lhs.window_show_state)
    return false;
  if (lhs.capture_sequence_number < rhs.capture_sequence_number)
    return true;
  if (rhs.capture_sequence_number < lhs.capture_sequence_number)
    return false;
  if (lhs.zoom_level < rhs.zoom_level)
    return true;
  if (rhs.zoom_level < lhs.zoom_level)
    return false;
  if (lhs.css_zoom_factor < rhs.css_zoom_factor)
    return true;
  if (rhs.css_zoom_factor < lhs.css_zoom_factor)
    return false;
  if (lhs.page_scale_factor < rhs.page_scale_factor)
    return true;
  if (rhs.page_scale_factor < lhs.page_scale_factor)
    return false;
  if (lhs.compositing_scale_factor < rhs.compositing_scale_factor)
    return true;
  if (rhs.compositing_scale_factor < lhs.compositing_scale_factor)
    return false;
  if (lhs.cursor_accessibility_scale_factor < rhs.cursor_accessibility_scale_factor)
    return true;
  if (rhs.cursor_accessibility_scale_factor < lhs.cursor_accessibility_scale_factor)
    return false;
  if (lhs.root_widget_viewport_segments < rhs.root_widget_viewport_segments)
    return true;
  if (rhs.root_widget_viewport_segments < lhs.root_widget_viewport_segments)
    return false;
  if (lhs.is_pinch_gesture_active < rhs.is_pinch_gesture_active)
    return true;
  if (rhs.is_pinch_gesture_active < lhs.is_pinch_gesture_active)
    return false;
  if (lhs.window_controls_overlay_rect < rhs.window_controls_overlay_rect)
    return true;
  if (rhs.window_controls_overlay_rect < lhs.window_controls_overlay_rect)
    return false;
  if (lhs.virtual_keyboard_resize_height_device_px < rhs.virtual_keyboard_resize_height_device_px)
    return true;
  if (rhs.virtual_keyboard_resize_height_device_px < lhs.virtual_keyboard_resize_height_device_px)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::VisualProperties::DataView,
                                         ::blink::mojom::blink::VisualPropertiesPtr> {
  static bool IsNull(const ::blink::mojom::blink::VisualPropertiesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::VisualPropertiesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::VisualProperties::screen_infos)& screen_infos(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->screen_infos;
  }

  static decltype(::blink::mojom::blink::VisualProperties::auto_resize_enabled) auto_resize_enabled(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->auto_resize_enabled;
  }

  static decltype(::blink::mojom::blink::VisualProperties::resizable) resizable(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->resizable;
  }

  static const decltype(::blink::mojom::blink::VisualProperties::min_size_for_auto_resize)& min_size_for_auto_resize(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->min_size_for_auto_resize;
  }

  static const decltype(::blink::mojom::blink::VisualProperties::max_size_for_auto_resize)& max_size_for_auto_resize(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->max_size_for_auto_resize;
  }

  static const decltype(::blink::mojom::blink::VisualProperties::new_size_device_px)& new_size_device_px(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->new_size_device_px;
  }

  static const decltype(::blink::mojom::blink::VisualProperties::visible_viewport_size_device_px)& visible_viewport_size_device_px(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->visible_viewport_size_device_px;
  }

  static const decltype(::blink::mojom::blink::VisualProperties::compositor_viewport_pixel_rect)& compositor_viewport_pixel_rect(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->compositor_viewport_pixel_rect;
  }

  static const decltype(::blink::mojom::blink::VisualProperties::browser_controls_params)& browser_controls_params(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->browser_controls_params;
  }

  static decltype(::blink::mojom::blink::VisualProperties::scroll_focused_node_into_view) scroll_focused_node_into_view(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->scroll_focused_node_into_view;
  }

  static const decltype(::blink::mojom::blink::VisualProperties::local_surface_id)& local_surface_id(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->local_surface_id;
  }

  static decltype(::blink::mojom::blink::VisualProperties::is_fullscreen_granted) is_fullscreen_granted(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->is_fullscreen_granted;
  }

  static decltype(::blink::mojom::blink::VisualProperties::display_mode) display_mode(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->display_mode;
  }

  static decltype(::blink::mojom::blink::VisualProperties::window_show_state) window_show_state(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->window_show_state;
  }

  static decltype(::blink::mojom::blink::VisualProperties::capture_sequence_number) capture_sequence_number(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->capture_sequence_number;
  }

  static decltype(::blink::mojom::blink::VisualProperties::zoom_level) zoom_level(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->zoom_level;
  }

  static decltype(::blink::mojom::blink::VisualProperties::css_zoom_factor) css_zoom_factor(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->css_zoom_factor;
  }

  static decltype(::blink::mojom::blink::VisualProperties::page_scale_factor) page_scale_factor(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->page_scale_factor;
  }

  static decltype(::blink::mojom::blink::VisualProperties::compositing_scale_factor) compositing_scale_factor(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->compositing_scale_factor;
  }

  static decltype(::blink::mojom::blink::VisualProperties::cursor_accessibility_scale_factor) cursor_accessibility_scale_factor(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->cursor_accessibility_scale_factor;
  }

  static const decltype(::blink::mojom::blink::VisualProperties::root_widget_viewport_segments)& root_widget_viewport_segments(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->root_widget_viewport_segments;
  }

  static decltype(::blink::mojom::blink::VisualProperties::is_pinch_gesture_active) is_pinch_gesture_active(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->is_pinch_gesture_active;
  }

  static const decltype(::blink::mojom::blink::VisualProperties::window_controls_overlay_rect)& window_controls_overlay_rect(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->window_controls_overlay_rect;
  }

  static decltype(::blink::mojom::blink::VisualProperties::virtual_keyboard_resize_height_device_px) virtual_keyboard_resize_height_device_px(
      const ::blink::mojom::blink::VisualPropertiesPtr& input) {
    return input->virtual_keyboard_resize_height_device_px;
  }

  static bool Read(::blink::mojom::blink::VisualProperties::DataView input, ::blink::mojom::blink::VisualPropertiesPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_VISUAL_PROPERTIES_MOJOM_BLINK_H_