// third_party/blink/public/mojom/widget/platform_widget.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/widget/platform_widget.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/widget/platform_widget.mojom-params-data.h"
#include "third_party/blink/public/mojom/widget/platform_widget.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/widget/platform_widget.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/widget/platform_widget.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

WidgetCompositor::IPCStableHashFunction WidgetCompositor::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WidgetCompositor>(message.name())) {
    case messages::WidgetCompositor::kVisualStateRequest: {
      return &WidgetCompositor::VisualStateRequest_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WidgetCompositor::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WidgetCompositor>(message.name())) {
      case messages::WidgetCompositor::kVisualStateRequest:
            return "Receive blink::mojom::WidgetCompositor::VisualStateRequest";
    }
  } else {
    switch (static_cast<messages::WidgetCompositor>(message.name())) {
      case messages::WidgetCompositor::kVisualStateRequest:
            return "Receive reply blink::mojom::WidgetCompositor::VisualStateRequest";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WidgetCompositor::VisualStateRequest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6c46dbc2;  // IPCStableHash for blink::mojom::WidgetCompositor::VisualStateRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WidgetCompositor_VisualStateRequest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WidgetCompositor_VisualStateRequest_ForwardToCallback(
      WidgetCompositor::VisualStateRequestCallback callback
      ) : callback_(std::move(callback)) {
  }

  WidgetCompositor_VisualStateRequest_ForwardToCallback(const WidgetCompositor_VisualStateRequest_ForwardToCallback&) = delete;
  WidgetCompositor_VisualStateRequest_ForwardToCallback& operator=(const WidgetCompositor_VisualStateRequest_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WidgetCompositor::VisualStateRequestCallback callback_;
};

WidgetCompositorProxy::WidgetCompositorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WidgetCompositorProxy::VisualStateRequest(
    VisualStateRequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::WidgetCompositor::VisualStateRequest");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetCompositor::kVisualStateRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetCompositor_VisualStateRequest_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetCompositor::Name_);
  message.set_method_name("VisualStateRequest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WidgetCompositor_VisualStateRequest_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WidgetCompositor_VisualStateRequest_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WidgetCompositor::VisualStateRequestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WidgetCompositor_VisualStateRequest_ProxyToResponder> proxy(
        new WidgetCompositor_VisualStateRequest_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WidgetCompositor_VisualStateRequest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WidgetCompositor_VisualStateRequest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WidgetCompositor_VisualStateRequest_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WidgetCompositor::VisualStateRequestCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool WidgetCompositor_VisualStateRequest_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WidgetCompositor_VisualStateRequest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WidgetCompositor_VisualStateRequest_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WidgetCompositor.0
  bool success = true;
  WidgetCompositor_VisualStateRequest_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WidgetCompositor::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void WidgetCompositor_VisualStateRequest_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::WidgetCompositor::VisualStateRequest");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetCompositor::kVisualStateRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetCompositor_VisualStateRequest_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetCompositor::Name_);
  message.set_method_name("VisualStateRequest");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WidgetCompositorStubDispatch::Accept(
    WidgetCompositor* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WidgetCompositor>(message->header()->name)) {
    case messages::WidgetCompositor::kVisualStateRequest: {
      break;
    }
  }
  return false;
}

// static
bool WidgetCompositorStubDispatch::AcceptWithResponder(
    WidgetCompositor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WidgetCompositor>(message->header()->name)) {
    case messages::WidgetCompositor::kVisualStateRequest: {
      internal::WidgetCompositor_VisualStateRequest_Params_Data* params =
          reinterpret_cast<
              internal::WidgetCompositor_VisualStateRequest_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WidgetCompositor.0
      bool success = true;
      WidgetCompositor_VisualStateRequest_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetCompositor::Name_, 0, false);
        return false;
      }
      auto callback =
          WidgetCompositor_VisualStateRequest_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->VisualStateRequest(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWidgetCompositorValidationInfo[] = {
    { &internal::WidgetCompositor_VisualStateRequest_Params_Data::Validate,
     &internal::WidgetCompositor_VisualStateRequest_ResponseParams_Data::Validate},
};

bool WidgetCompositorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::WidgetCompositor::Name_,
    kWidgetCompositorValidationInfo);
}

bool WidgetCompositorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::WidgetCompositor::Name_,
    kWidgetCompositorValidationInfo);
}
// The declaration includes the definition on other builds.

WidgetHost::IPCStableHashFunction WidgetHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WidgetHost>(message.name())) {
    case messages::WidgetHost::kSetCursor: {
      return &WidgetHost::SetCursor_Sym::IPCStableHash;
    }
    case messages::WidgetHost::kUpdateTooltipUnderCursor: {
      return &WidgetHost::UpdateTooltipUnderCursor_Sym::IPCStableHash;
    }
    case messages::WidgetHost::kUpdateTooltipFromKeyboard: {
      return &WidgetHost::UpdateTooltipFromKeyboard_Sym::IPCStableHash;
    }
    case messages::WidgetHost::kClearKeyboardTriggeredTooltip: {
      return &WidgetHost::ClearKeyboardTriggeredTooltip_Sym::IPCStableHash;
    }
    case messages::WidgetHost::kTextInputStateChanged: {
      return &WidgetHost::TextInputStateChanged_Sym::IPCStableHash;
    }
    case messages::WidgetHost::kSelectionBoundsChanged: {
      return &WidgetHost::SelectionBoundsChanged_Sym::IPCStableHash;
    }
    case messages::WidgetHost::kCreateFrameSink: {
      return &WidgetHost::CreateFrameSink_Sym::IPCStableHash;
    }
    case messages::WidgetHost::kRegisterRenderFrameMetadataObserver: {
      return &WidgetHost::RegisterRenderFrameMetadataObserver_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WidgetHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WidgetHost>(message.name())) {
      case messages::WidgetHost::kSetCursor:
            return "Receive blink::mojom::WidgetHost::SetCursor";
      case messages::WidgetHost::kUpdateTooltipUnderCursor:
            return "Receive blink::mojom::WidgetHost::UpdateTooltipUnderCursor";
      case messages::WidgetHost::kUpdateTooltipFromKeyboard:
            return "Receive blink::mojom::WidgetHost::UpdateTooltipFromKeyboard";
      case messages::WidgetHost::kClearKeyboardTriggeredTooltip:
            return "Receive blink::mojom::WidgetHost::ClearKeyboardTriggeredTooltip";
      case messages::WidgetHost::kTextInputStateChanged:
            return "Receive blink::mojom::WidgetHost::TextInputStateChanged";
      case messages::WidgetHost::kSelectionBoundsChanged:
            return "Receive blink::mojom::WidgetHost::SelectionBoundsChanged";
      case messages::WidgetHost::kCreateFrameSink:
            return "Receive blink::mojom::WidgetHost::CreateFrameSink";
      case messages::WidgetHost::kRegisterRenderFrameMetadataObserver:
            return "Receive blink::mojom::WidgetHost::RegisterRenderFrameMetadataObserver";
    }
  } else {
    switch (static_cast<messages::WidgetHost>(message.name())) {
      case messages::WidgetHost::kSetCursor:
            return "Receive reply blink::mojom::WidgetHost::SetCursor";
      case messages::WidgetHost::kUpdateTooltipUnderCursor:
            return "Receive reply blink::mojom::WidgetHost::UpdateTooltipUnderCursor";
      case messages::WidgetHost::kUpdateTooltipFromKeyboard:
            return "Receive reply blink::mojom::WidgetHost::UpdateTooltipFromKeyboard";
      case messages::WidgetHost::kClearKeyboardTriggeredTooltip:
            return "Receive reply blink::mojom::WidgetHost::ClearKeyboardTriggeredTooltip";
      case messages::WidgetHost::kTextInputStateChanged:
            return "Receive reply blink::mojom::WidgetHost::TextInputStateChanged";
      case messages::WidgetHost::kSelectionBoundsChanged:
            return "Receive reply blink::mojom::WidgetHost::SelectionBoundsChanged";
      case messages::WidgetHost::kCreateFrameSink:
            return "Receive reply blink::mojom::WidgetHost::CreateFrameSink";
      case messages::WidgetHost::kRegisterRenderFrameMetadataObserver:
            return "Receive reply blink::mojom::WidgetHost::RegisterRenderFrameMetadataObserver";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WidgetHost::SetCursor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf5a9f07a;  // IPCStableHash for blink::mojom::WidgetHost::SetCursor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetHost::UpdateTooltipUnderCursor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1ca743f7;  // IPCStableHash for blink::mojom::WidgetHost::UpdateTooltipUnderCursor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetHost::UpdateTooltipFromKeyboard_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbf9bb90a;  // IPCStableHash for blink::mojom::WidgetHost::UpdateTooltipFromKeyboard
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetHost::ClearKeyboardTriggeredTooltip_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfce5826f;  // IPCStableHash for blink::mojom::WidgetHost::ClearKeyboardTriggeredTooltip
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetHost::TextInputStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x43e3ccc8;  // IPCStableHash for blink::mojom::WidgetHost::TextInputStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetHost::SelectionBoundsChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0c3f839c;  // IPCStableHash for blink::mojom::WidgetHost::SelectionBoundsChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetHost::CreateFrameSink_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x74cf16c0;  // IPCStableHash for blink::mojom::WidgetHost::CreateFrameSink
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetHost::RegisterRenderFrameMetadataObserver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3f05bc23;  // IPCStableHash for blink::mojom::WidgetHost::RegisterRenderFrameMetadataObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WidgetHostProxy::WidgetHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WidgetHostProxy::SetCursor(
    const ::ui::Cursor& in_cursor) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetHost::SetCursor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cursor"), in_cursor,
                        "<value of type const ::ui::Cursor&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetHost::kSetCursor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetHost_SetCursor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cursor)::BaseType> cursor_fragment(
          params.message());
  
  mojo::internal::Serialize<::ui::mojom::CursorDataView>(
    in_cursor,
    cursor_fragment);

  params->cursor.Set(
      cursor_fragment.is_null() ? nullptr : cursor_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cursor.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cursor in WidgetHost.SetCursor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetHost::Name_);
  message.set_method_name("SetCursor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetHostProxy::UpdateTooltipUnderCursor(
    const ::blink::String& in_tooltip_text, ::base::i18n::TextDirection in_text_direction_hint) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetHost::UpdateTooltipUnderCursor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tooltip_text"), in_tooltip_text,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text_direction_hint"), in_text_direction_hint,
                        "<value of type ::base::i18n::TextDirection>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetHost::kUpdateTooltipUnderCursor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetHost_UpdateTooltipUnderCursor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tooltip_text)::BaseType> tooltip_text_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_tooltip_text,
    tooltip_text_fragment);

  params->tooltip_text.Set(
      tooltip_text_fragment.is_null() ? nullptr : tooltip_text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tooltip_text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tooltip_text in WidgetHost.UpdateTooltipUnderCursor request");

  
  mojo::internal::Serialize<::mojo_base::mojom::TextDirection>(
    in_text_direction_hint,
    &params->text_direction_hint);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetHost::Name_);
  message.set_method_name("UpdateTooltipUnderCursor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetHostProxy::UpdateTooltipFromKeyboard(
    const ::blink::String& in_tooltip_text, ::base::i18n::TextDirection in_text_direction_hint, const ::gfx::Rect& in_bounds) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetHost::UpdateTooltipFromKeyboard", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tooltip_text"), in_tooltip_text,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text_direction_hint"), in_text_direction_hint,
                        "<value of type ::base::i18n::TextDirection>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds"), in_bounds,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetHost::kUpdateTooltipFromKeyboard), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetHost_UpdateTooltipFromKeyboard_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tooltip_text)::BaseType> tooltip_text_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_tooltip_text,
    tooltip_text_fragment);

  params->tooltip_text.Set(
      tooltip_text_fragment.is_null() ? nullptr : tooltip_text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tooltip_text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tooltip_text in WidgetHost.UpdateTooltipFromKeyboard request");

  
  mojo::internal::Serialize<::mojo_base::mojom::TextDirection>(
    in_text_direction_hint,
    &params->text_direction_hint);
  mojo::internal::MessageFragment<
      typename decltype(params->bounds)::BaseType> bounds_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_bounds,
    bounds_fragment);

  params->bounds.Set(
      bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bounds.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bounds in WidgetHost.UpdateTooltipFromKeyboard request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetHost::Name_);
  message.set_method_name("UpdateTooltipFromKeyboard");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetHostProxy::ClearKeyboardTriggeredTooltip(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::WidgetHost::ClearKeyboardTriggeredTooltip");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetHost::kClearKeyboardTriggeredTooltip), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetHost_ClearKeyboardTriggeredTooltip_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetHost::Name_);
  message.set_method_name("ClearKeyboardTriggeredTooltip");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetHostProxy::TextInputStateChanged(
    ::ui::mojom::blink::TextInputStatePtr in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetHost::TextInputStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type ::ui::mojom::blink::TextInputStatePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetHost::kTextInputStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetHost_TextInputStateChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  
  mojo::internal::Serialize<::ui::mojom::TextInputStateDataView>(
    in_state,
    state_fragment);

  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null state in WidgetHost.TextInputStateChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetHost::Name_);
  message.set_method_name("TextInputStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetHostProxy::SelectionBoundsChanged(
    const ::gfx::Rect& in_anchor_rect, ::base::i18n::TextDirection in_anchor_dir, const ::gfx::Rect& in_focus_rect, ::base::i18n::TextDirection in_focus_dir, const ::gfx::Rect& in_bounding_box_rect, bool in_is_anchor_first) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetHost::SelectionBoundsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("anchor_rect"), in_anchor_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("anchor_dir"), in_anchor_dir,
                        "<value of type ::base::i18n::TextDirection>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("focus_rect"), in_focus_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("focus_dir"), in_focus_dir,
                        "<value of type ::base::i18n::TextDirection>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounding_box_rect"), in_bounding_box_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_anchor_first"), in_is_anchor_first,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetHost::kSelectionBoundsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetHost_SelectionBoundsChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->anchor_rect)::BaseType> anchor_rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_anchor_rect,
    anchor_rect_fragment);

  params->anchor_rect.Set(
      anchor_rect_fragment.is_null() ? nullptr : anchor_rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->anchor_rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null anchor_rect in WidgetHost.SelectionBoundsChanged request");

  
  mojo::internal::Serialize<::mojo_base::mojom::TextDirection>(
    in_anchor_dir,
    &params->anchor_dir);
  mojo::internal::MessageFragment<
      typename decltype(params->focus_rect)::BaseType> focus_rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_focus_rect,
    focus_rect_fragment);

  params->focus_rect.Set(
      focus_rect_fragment.is_null() ? nullptr : focus_rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->focus_rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null focus_rect in WidgetHost.SelectionBoundsChanged request");

  
  mojo::internal::Serialize<::mojo_base::mojom::TextDirection>(
    in_focus_dir,
    &params->focus_dir);
  mojo::internal::MessageFragment<
      typename decltype(params->bounding_box_rect)::BaseType> bounding_box_rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_bounding_box_rect,
    bounding_box_rect_fragment);

  params->bounding_box_rect.Set(
      bounding_box_rect_fragment.is_null() ? nullptr : bounding_box_rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bounding_box_rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bounding_box_rect in WidgetHost.SelectionBoundsChanged request");

  params->is_anchor_first = in_is_anchor_first;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetHost::Name_);
  message.set_method_name("SelectionBoundsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetHostProxy::CreateFrameSink(
    ::mojo::PendingReceiver<::viz::mojom::blink::CompositorFrameSink> in_compositor_frame_sink_receiver, ::mojo::PendingRemote<::viz::mojom::blink::CompositorFrameSinkClient> in_compositor_frame_sink_client, ::mojo::PendingRemote<RenderInputRouterClient> in_render_input_router_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetHost::CreateFrameSink", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("compositor_frame_sink_receiver"), in_compositor_frame_sink_receiver,
                        "<value of type ::mojo::PendingReceiver<::viz::mojom::blink::CompositorFrameSink>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("compositor_frame_sink_client"), in_compositor_frame_sink_client,
                        "<value of type ::mojo::PendingRemote<::viz::mojom::blink::CompositorFrameSinkClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("render_input_router_client"), in_render_input_router_client,
                        "<value of type ::mojo::PendingRemote<RenderInputRouterClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetHost::kCreateFrameSink), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetHost_CreateFrameSink_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::CompositorFrameSinkInterfaceBase>>(
    in_compositor_frame_sink_receiver,
    &params->compositor_frame_sink_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->compositor_frame_sink_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid compositor_frame_sink_receiver in WidgetHost.CreateFrameSink request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::CompositorFrameSinkClientInterfaceBase>>(
    in_compositor_frame_sink_client,
    &params->compositor_frame_sink_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->compositor_frame_sink_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid compositor_frame_sink_client in WidgetHost.CreateFrameSink request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::RenderInputRouterClientInterfaceBase>>(
    in_render_input_router_client,
    &params->render_input_router_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->render_input_router_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid render_input_router_client in WidgetHost.CreateFrameSink request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetHost::Name_);
  message.set_method_name("CreateFrameSink");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetHostProxy::RegisterRenderFrameMetadataObserver(
    ::mojo::PendingReceiver<::cc::mojom::blink::RenderFrameMetadataObserverClient> in_render_frame_metadata_observer_client_receiver, ::mojo::PendingRemote<::cc::mojom::blink::RenderFrameMetadataObserver> in_render_frame_metadata_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetHost::RegisterRenderFrameMetadataObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("render_frame_metadata_observer_client_receiver"), in_render_frame_metadata_observer_client_receiver,
                        "<value of type ::mojo::PendingReceiver<::cc::mojom::blink::RenderFrameMetadataObserverClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("render_frame_metadata_observer"), in_render_frame_metadata_observer,
                        "<value of type ::mojo::PendingRemote<::cc::mojom::blink::RenderFrameMetadataObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetHost::kRegisterRenderFrameMetadataObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetHost_RegisterRenderFrameMetadataObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::cc::mojom::RenderFrameMetadataObserverClientInterfaceBase>>(
    in_render_frame_metadata_observer_client_receiver,
    &params->render_frame_metadata_observer_client_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->render_frame_metadata_observer_client_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid render_frame_metadata_observer_client_receiver in WidgetHost.RegisterRenderFrameMetadataObserver request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::cc::mojom::RenderFrameMetadataObserverInterfaceBase>>(
    in_render_frame_metadata_observer,
    &params->render_frame_metadata_observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->render_frame_metadata_observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid render_frame_metadata_observer in WidgetHost.RegisterRenderFrameMetadataObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetHost::Name_);
  message.set_method_name("RegisterRenderFrameMetadataObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WidgetHostStubDispatch::Accept(
    WidgetHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WidgetHost>(message->header()->name)) {
    case messages::WidgetHost::kSetCursor: {
      DCHECK(message->is_serialized());
      internal::WidgetHost_SetCursor_Params_Data* params =
          reinterpret_cast<internal::WidgetHost_SetCursor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetHost.0
      bool success = true;
      ::ui::Cursor p_cursor{};
      WidgetHost_SetCursor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCursor(&p_cursor))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCursor(        
        std::move(p_cursor));
      return true;
    }
    case messages::WidgetHost::kUpdateTooltipUnderCursor: {
      DCHECK(message->is_serialized());
      internal::WidgetHost_UpdateTooltipUnderCursor_Params_Data* params =
          reinterpret_cast<internal::WidgetHost_UpdateTooltipUnderCursor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetHost.1
      bool success = true;
      ::blink::String p_tooltip_text{};
      ::base::i18n::TextDirection p_text_direction_hint{};
      WidgetHost_UpdateTooltipUnderCursor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTooltipText(&p_tooltip_text))
        success = false;
      if (success && !input_data_view.ReadTextDirectionHint(&p_text_direction_hint))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateTooltipUnderCursor(        
        std::move(p_tooltip_text), 
        std::move(p_text_direction_hint));
      return true;
    }
    case messages::WidgetHost::kUpdateTooltipFromKeyboard: {
      DCHECK(message->is_serialized());
      internal::WidgetHost_UpdateTooltipFromKeyboard_Params_Data* params =
          reinterpret_cast<internal::WidgetHost_UpdateTooltipFromKeyboard_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetHost.2
      bool success = true;
      ::blink::String p_tooltip_text{};
      ::base::i18n::TextDirection p_text_direction_hint{};
      ::gfx::Rect p_bounds{};
      WidgetHost_UpdateTooltipFromKeyboard_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTooltipText(&p_tooltip_text))
        success = false;
      if (success && !input_data_view.ReadTextDirectionHint(&p_text_direction_hint))
        success = false;
      if (success && !input_data_view.ReadBounds(&p_bounds))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateTooltipFromKeyboard(        
        std::move(p_tooltip_text), 
        std::move(p_text_direction_hint), 
        std::move(p_bounds));
      return true;
    }
    case messages::WidgetHost::kClearKeyboardTriggeredTooltip: {
      DCHECK(message->is_serialized());
      internal::WidgetHost_ClearKeyboardTriggeredTooltip_Params_Data* params =
          reinterpret_cast<internal::WidgetHost_ClearKeyboardTriggeredTooltip_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetHost.3
      bool success = true;
      WidgetHost_ClearKeyboardTriggeredTooltip_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearKeyboardTriggeredTooltip(        );
      return true;
    }
    case messages::WidgetHost::kTextInputStateChanged: {
      DCHECK(message->is_serialized());
      internal::WidgetHost_TextInputStateChanged_Params_Data* params =
          reinterpret_cast<internal::WidgetHost_TextInputStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetHost.4
      bool success = true;
      ::ui::mojom::blink::TextInputStatePtr p_state{};
      WidgetHost_TextInputStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TextInputStateChanged(        
        std::move(p_state));
      return true;
    }
    case messages::WidgetHost::kSelectionBoundsChanged: {
      DCHECK(message->is_serialized());
      internal::WidgetHost_SelectionBoundsChanged_Params_Data* params =
          reinterpret_cast<internal::WidgetHost_SelectionBoundsChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetHost.5
      bool success = true;
      ::gfx::Rect p_anchor_rect{};
      ::base::i18n::TextDirection p_anchor_dir{};
      ::gfx::Rect p_focus_rect{};
      ::base::i18n::TextDirection p_focus_dir{};
      ::gfx::Rect p_bounding_box_rect{};
      bool p_is_anchor_first{};
      WidgetHost_SelectionBoundsChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAnchorRect(&p_anchor_rect))
        success = false;
      if (success && !input_data_view.ReadAnchorDir(&p_anchor_dir))
        success = false;
      if (success && !input_data_view.ReadFocusRect(&p_focus_rect))
        success = false;
      if (success && !input_data_view.ReadFocusDir(&p_focus_dir))
        success = false;
      if (success && !input_data_view.ReadBoundingBoxRect(&p_bounding_box_rect))
        success = false;
      if (success)
        p_is_anchor_first = input_data_view.is_anchor_first();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SelectionBoundsChanged(        
        std::move(p_anchor_rect), 
        std::move(p_anchor_dir), 
        std::move(p_focus_rect), 
        std::move(p_focus_dir), 
        std::move(p_bounding_box_rect), 
        std::move(p_is_anchor_first));
      return true;
    }
    case messages::WidgetHost::kCreateFrameSink: {
      DCHECK(message->is_serialized());
      internal::WidgetHost_CreateFrameSink_Params_Data* params =
          reinterpret_cast<internal::WidgetHost_CreateFrameSink_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetHost.6
      bool success = true;
      ::mojo::PendingReceiver<::viz::mojom::blink::CompositorFrameSink> p_compositor_frame_sink_receiver{};
      ::mojo::PendingRemote<::viz::mojom::blink::CompositorFrameSinkClient> p_compositor_frame_sink_client{};
      ::mojo::PendingRemote<RenderInputRouterClient> p_render_input_router_client{};
      WidgetHost_CreateFrameSink_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_compositor_frame_sink_receiver =
            input_data_view.TakeCompositorFrameSinkReceiver<decltype(p_compositor_frame_sink_receiver)>();
      }
      if (success) {
        p_compositor_frame_sink_client =
            input_data_view.TakeCompositorFrameSinkClient<decltype(p_compositor_frame_sink_client)>();
      }
      if (success) {
        p_render_input_router_client =
            input_data_view.TakeRenderInputRouterClient<decltype(p_render_input_router_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateFrameSink(        
        std::move(p_compositor_frame_sink_receiver), 
        std::move(p_compositor_frame_sink_client), 
        std::move(p_render_input_router_client));
      return true;
    }
    case messages::WidgetHost::kRegisterRenderFrameMetadataObserver: {
      DCHECK(message->is_serialized());
      internal::WidgetHost_RegisterRenderFrameMetadataObserver_Params_Data* params =
          reinterpret_cast<internal::WidgetHost_RegisterRenderFrameMetadataObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetHost.7
      bool success = true;
      ::mojo::PendingReceiver<::cc::mojom::blink::RenderFrameMetadataObserverClient> p_render_frame_metadata_observer_client_receiver{};
      ::mojo::PendingRemote<::cc::mojom::blink::RenderFrameMetadataObserver> p_render_frame_metadata_observer{};
      WidgetHost_RegisterRenderFrameMetadataObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_render_frame_metadata_observer_client_receiver =
            input_data_view.TakeRenderFrameMetadataObserverClientReceiver<decltype(p_render_frame_metadata_observer_client_receiver)>();
      }
      if (success) {
        p_render_frame_metadata_observer =
            input_data_view.TakeRenderFrameMetadataObserver<decltype(p_render_frame_metadata_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterRenderFrameMetadataObserver(        
        std::move(p_render_frame_metadata_observer_client_receiver), 
        std::move(p_render_frame_metadata_observer));
      return true;
    }
  }
  return false;
}

// static
bool WidgetHostStubDispatch::AcceptWithResponder(
    WidgetHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WidgetHost>(message->header()->name)) {
    case messages::WidgetHost::kSetCursor: {
      break;
    }
    case messages::WidgetHost::kUpdateTooltipUnderCursor: {
      break;
    }
    case messages::WidgetHost::kUpdateTooltipFromKeyboard: {
      break;
    }
    case messages::WidgetHost::kClearKeyboardTriggeredTooltip: {
      break;
    }
    case messages::WidgetHost::kTextInputStateChanged: {
      break;
    }
    case messages::WidgetHost::kSelectionBoundsChanged: {
      break;
    }
    case messages::WidgetHost::kCreateFrameSink: {
      break;
    }
    case messages::WidgetHost::kRegisterRenderFrameMetadataObserver: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWidgetHostValidationInfo[] = {
    { &internal::WidgetHost_SetCursor_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetHost_UpdateTooltipUnderCursor_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetHost_UpdateTooltipFromKeyboard_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetHost_ClearKeyboardTriggeredTooltip_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetHost_TextInputStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetHost_SelectionBoundsChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetHost_CreateFrameSink_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetHost_RegisterRenderFrameMetadataObserver_Params_Data::Validate,
     nullptr /* no response */},
};

bool WidgetHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::WidgetHost::Name_,
    kWidgetHostValidationInfo);
}

// The declaration includes the definition on other builds.

Widget::IPCStableHashFunction Widget::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Widget>(message.name())) {
    case messages::Widget::kForceRedraw: {
      return &Widget::ForceRedraw_Sym::IPCStableHash;
    }
    case messages::Widget::kUpdateVisualProperties: {
      return &Widget::UpdateVisualProperties_Sym::IPCStableHash;
    }
    case messages::Widget::kUpdateScreenRects: {
      return &Widget::UpdateScreenRects_Sym::IPCStableHash;
    }
    case messages::Widget::kWasHidden: {
      return &Widget::WasHidden_Sym::IPCStableHash;
    }
    case messages::Widget::kWasShown: {
      return &Widget::WasShown_Sym::IPCStableHash;
    }
    case messages::Widget::kRequestSuccessfulPresentationTimeForNextFrame: {
      return &Widget::RequestSuccessfulPresentationTimeForNextFrame_Sym::IPCStableHash;
    }
    case messages::Widget::kCancelSuccessfulPresentationTimeRequest: {
      return &Widget::CancelSuccessfulPresentationTimeRequest_Sym::IPCStableHash;
    }
    case messages::Widget::kSetupBrowserRenderInputRouterConnections: {
      return &Widget::SetupBrowserRenderInputRouterConnections_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Widget::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Widget>(message.name())) {
      case messages::Widget::kForceRedraw:
            return "Receive blink::mojom::Widget::ForceRedraw";
      case messages::Widget::kUpdateVisualProperties:
            return "Receive blink::mojom::Widget::UpdateVisualProperties";
      case messages::Widget::kUpdateScreenRects:
            return "Receive blink::mojom::Widget::UpdateScreenRects";
      case messages::Widget::kWasHidden:
            return "Receive blink::mojom::Widget::WasHidden";
      case messages::Widget::kWasShown:
            return "Receive blink::mojom::Widget::WasShown";
      case messages::Widget::kRequestSuccessfulPresentationTimeForNextFrame:
            return "Receive blink::mojom::Widget::RequestSuccessfulPresentationTimeForNextFrame";
      case messages::Widget::kCancelSuccessfulPresentationTimeRequest:
            return "Receive blink::mojom::Widget::CancelSuccessfulPresentationTimeRequest";
      case messages::Widget::kSetupBrowserRenderInputRouterConnections:
            return "Receive blink::mojom::Widget::SetupBrowserRenderInputRouterConnections";
    }
  } else {
    switch (static_cast<messages::Widget>(message.name())) {
      case messages::Widget::kForceRedraw:
            return "Receive reply blink::mojom::Widget::ForceRedraw";
      case messages::Widget::kUpdateVisualProperties:
            return "Receive reply blink::mojom::Widget::UpdateVisualProperties";
      case messages::Widget::kUpdateScreenRects:
            return "Receive reply blink::mojom::Widget::UpdateScreenRects";
      case messages::Widget::kWasHidden:
            return "Receive reply blink::mojom::Widget::WasHidden";
      case messages::Widget::kWasShown:
            return "Receive reply blink::mojom::Widget::WasShown";
      case messages::Widget::kRequestSuccessfulPresentationTimeForNextFrame:
            return "Receive reply blink::mojom::Widget::RequestSuccessfulPresentationTimeForNextFrame";
      case messages::Widget::kCancelSuccessfulPresentationTimeRequest:
            return "Receive reply blink::mojom::Widget::CancelSuccessfulPresentationTimeRequest";
      case messages::Widget::kSetupBrowserRenderInputRouterConnections:
            return "Receive reply blink::mojom::Widget::SetupBrowserRenderInputRouterConnections";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Widget::ForceRedraw_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1e921acd;  // IPCStableHash for blink::mojom::Widget::ForceRedraw
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Widget::UpdateVisualProperties_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe5f8847d;  // IPCStableHash for blink::mojom::Widget::UpdateVisualProperties
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Widget::UpdateScreenRects_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8a0e5ce4;  // IPCStableHash for blink::mojom::Widget::UpdateScreenRects
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Widget::WasHidden_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x96ff6f04;  // IPCStableHash for blink::mojom::Widget::WasHidden
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Widget::WasShown_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3cdb0f1d;  // IPCStableHash for blink::mojom::Widget::WasShown
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Widget::RequestSuccessfulPresentationTimeForNextFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0be51788;  // IPCStableHash for blink::mojom::Widget::RequestSuccessfulPresentationTimeForNextFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Widget::CancelSuccessfulPresentationTimeRequest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xedaef467;  // IPCStableHash for blink::mojom::Widget::CancelSuccessfulPresentationTimeRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Widget::SetupBrowserRenderInputRouterConnections_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4a143e42;  // IPCStableHash for blink::mojom::Widget::SetupBrowserRenderInputRouterConnections
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Widget_ForceRedraw_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Widget_ForceRedraw_ForwardToCallback(
      Widget::ForceRedrawCallback callback
      ) : callback_(std::move(callback)) {
  }

  Widget_ForceRedraw_ForwardToCallback(const Widget_ForceRedraw_ForwardToCallback&) = delete;
  Widget_ForceRedraw_ForwardToCallback& operator=(const Widget_ForceRedraw_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Widget::ForceRedrawCallback callback_;
};

class Widget_UpdateScreenRects_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Widget_UpdateScreenRects_ForwardToCallback(
      Widget::UpdateScreenRectsCallback callback
      ) : callback_(std::move(callback)) {
  }

  Widget_UpdateScreenRects_ForwardToCallback(const Widget_UpdateScreenRects_ForwardToCallback&) = delete;
  Widget_UpdateScreenRects_ForwardToCallback& operator=(const Widget_UpdateScreenRects_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Widget::UpdateScreenRectsCallback callback_;
};

WidgetProxy::WidgetProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WidgetProxy::ForceRedraw(
    ForceRedrawCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::Widget::ForceRedraw");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Widget::kForceRedraw), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Widget_ForceRedraw_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Widget::Name_);
  message.set_method_name("ForceRedraw");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Widget_ForceRedraw_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WidgetProxy::UpdateVisualProperties(
    const ::blink::VisualProperties& in_visual_properties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::Widget::UpdateVisualProperties", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visual_properties"), in_visual_properties,
                        "<value of type const ::blink::VisualProperties&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Widget::kUpdateVisualProperties), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Widget_UpdateVisualProperties_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->visual_properties)::BaseType> visual_properties_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::VisualPropertiesDataView>(
    in_visual_properties,
    visual_properties_fragment);

  params->visual_properties.Set(
      visual_properties_fragment.is_null() ? nullptr : visual_properties_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->visual_properties.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null visual_properties in Widget.UpdateVisualProperties request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Widget::Name_);
  message.set_method_name("UpdateVisualProperties");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetProxy::UpdateScreenRects(
    const ::gfx::Rect& in_widget_screen_rect, const ::gfx::Rect& in_window_screen_rect, UpdateScreenRectsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::Widget::UpdateScreenRects", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("widget_screen_rect"), in_widget_screen_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_screen_rect"), in_window_screen_rect,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Widget::kUpdateScreenRects), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Widget_UpdateScreenRects_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->widget_screen_rect)::BaseType> widget_screen_rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_widget_screen_rect,
    widget_screen_rect_fragment);

  params->widget_screen_rect.Set(
      widget_screen_rect_fragment.is_null() ? nullptr : widget_screen_rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->widget_screen_rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null widget_screen_rect in Widget.UpdateScreenRects request");
  mojo::internal::MessageFragment<
      typename decltype(params->window_screen_rect)::BaseType> window_screen_rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_window_screen_rect,
    window_screen_rect_fragment);

  params->window_screen_rect.Set(
      window_screen_rect_fragment.is_null() ? nullptr : window_screen_rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->window_screen_rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null window_screen_rect in Widget.UpdateScreenRects request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Widget::Name_);
  message.set_method_name("UpdateScreenRects");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Widget_UpdateScreenRects_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WidgetProxy::WasHidden(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::Widget::WasHidden");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Widget::kWasHidden), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Widget_WasHidden_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Widget::Name_);
  message.set_method_name("WasHidden");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetProxy::WasShown(
    bool in_was_evicted, ::blink::mojom::blink::RecordContentToVisibleTimeRequestPtr in_record_tab_switch_time_request) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::Widget::WasShown", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("was_evicted"), in_was_evicted,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("record_tab_switch_time_request"), in_record_tab_switch_time_request,
                        "<value of type ::blink::mojom::blink::RecordContentToVisibleTimeRequestPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Widget::kWasShown), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Widget_WasShown_Params_Data> params(
          message);
  params.Allocate();

  params->was_evicted = in_was_evicted;
  mojo::internal::MessageFragment<
      typename decltype(params->record_tab_switch_time_request)::BaseType> record_tab_switch_time_request_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RecordContentToVisibleTimeRequestDataView>(
    in_record_tab_switch_time_request,
    record_tab_switch_time_request_fragment);

  params->record_tab_switch_time_request.Set(
      record_tab_switch_time_request_fragment.is_null() ? nullptr : record_tab_switch_time_request_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Widget::Name_);
  message.set_method_name("WasShown");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetProxy::RequestSuccessfulPresentationTimeForNextFrame(
    ::blink::mojom::blink::RecordContentToVisibleTimeRequestPtr in_visible_time_request) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::Widget::RequestSuccessfulPresentationTimeForNextFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible_time_request"), in_visible_time_request,
                        "<value of type ::blink::mojom::blink::RecordContentToVisibleTimeRequestPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Widget::kRequestSuccessfulPresentationTimeForNextFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Widget_RequestSuccessfulPresentationTimeForNextFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->visible_time_request)::BaseType> visible_time_request_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RecordContentToVisibleTimeRequestDataView>(
    in_visible_time_request,
    visible_time_request_fragment);

  params->visible_time_request.Set(
      visible_time_request_fragment.is_null() ? nullptr : visible_time_request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->visible_time_request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null visible_time_request in Widget.RequestSuccessfulPresentationTimeForNextFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Widget::Name_);
  message.set_method_name("RequestSuccessfulPresentationTimeForNextFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetProxy::CancelSuccessfulPresentationTimeRequest(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::Widget::CancelSuccessfulPresentationTimeRequest");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Widget::kCancelSuccessfulPresentationTimeRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Widget_CancelSuccessfulPresentationTimeRequest_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Widget::Name_);
  message.set_method_name("CancelSuccessfulPresentationTimeRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetProxy::SetupBrowserRenderInputRouterConnections(
    ::mojo::PendingReceiver<RenderInputRouterClient> in_browser_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::Widget::SetupBrowserRenderInputRouterConnections", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_client"), in_browser_client,
                        "<value of type ::mojo::PendingReceiver<RenderInputRouterClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Widget::kSetupBrowserRenderInputRouterConnections), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Widget_SetupBrowserRenderInputRouterConnections_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::RenderInputRouterClientInterfaceBase>>(
    in_browser_client,
    &params->browser_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->browser_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid browser_client in Widget.SetupBrowserRenderInputRouterConnections request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Widget::Name_);
  message.set_method_name("SetupBrowserRenderInputRouterConnections");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class Widget_ForceRedraw_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Widget::ForceRedrawCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Widget_ForceRedraw_ProxyToResponder> proxy(
        new Widget_ForceRedraw_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Widget_ForceRedraw_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Widget_ForceRedraw_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Widget_ForceRedraw_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Widget::ForceRedrawCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool Widget_ForceRedraw_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Widget_ForceRedraw_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Widget_ForceRedraw_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Widget.0
  bool success = true;
  Widget_ForceRedraw_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Widget::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void Widget_ForceRedraw_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::Widget::ForceRedraw");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Widget::kForceRedraw), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Widget_ForceRedraw_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Widget::Name_);
  message.set_method_name("ForceRedraw");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Widget_UpdateScreenRects_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Widget::UpdateScreenRectsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Widget_UpdateScreenRects_ProxyToResponder> proxy(
        new Widget_UpdateScreenRects_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Widget_UpdateScreenRects_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Widget_UpdateScreenRects_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Widget_UpdateScreenRects_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Widget::UpdateScreenRectsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool Widget_UpdateScreenRects_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Widget_UpdateScreenRects_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Widget_UpdateScreenRects_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Widget.2
  bool success = true;
  Widget_UpdateScreenRects_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Widget::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void Widget_UpdateScreenRects_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::Widget::UpdateScreenRects");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Widget::kUpdateScreenRects), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Widget_UpdateScreenRects_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Widget::Name_);
  message.set_method_name("UpdateScreenRects");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WidgetStubDispatch::Accept(
    Widget* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Widget>(message->header()->name)) {
    case messages::Widget::kForceRedraw: {
      break;
    }
    case messages::Widget::kUpdateVisualProperties: {
      DCHECK(message->is_serialized());
      internal::Widget_UpdateVisualProperties_Params_Data* params =
          reinterpret_cast<internal::Widget_UpdateVisualProperties_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Widget.1
      bool success = true;
      ::blink::VisualProperties p_visual_properties{};
      Widget_UpdateVisualProperties_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVisualProperties(&p_visual_properties))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Widget::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateVisualProperties(        
        std::move(p_visual_properties));
      return true;
    }
    case messages::Widget::kUpdateScreenRects: {
      break;
    }
    case messages::Widget::kWasHidden: {
      DCHECK(message->is_serialized());
      internal::Widget_WasHidden_Params_Data* params =
          reinterpret_cast<internal::Widget_WasHidden_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Widget.3
      bool success = true;
      Widget_WasHidden_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Widget::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WasHidden(        );
      return true;
    }
    case messages::Widget::kWasShown: {
      DCHECK(message->is_serialized());
      internal::Widget_WasShown_Params_Data* params =
          reinterpret_cast<internal::Widget_WasShown_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Widget.4
      bool success = true;
      bool p_was_evicted{};
      ::blink::mojom::blink::RecordContentToVisibleTimeRequestPtr p_record_tab_switch_time_request{};
      Widget_WasShown_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_was_evicted = input_data_view.was_evicted();
      if (success && !input_data_view.ReadRecordTabSwitchTimeRequest(&p_record_tab_switch_time_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Widget::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WasShown(        
        std::move(p_was_evicted), 
        std::move(p_record_tab_switch_time_request));
      return true;
    }
    case messages::Widget::kRequestSuccessfulPresentationTimeForNextFrame: {
      DCHECK(message->is_serialized());
      internal::Widget_RequestSuccessfulPresentationTimeForNextFrame_Params_Data* params =
          reinterpret_cast<internal::Widget_RequestSuccessfulPresentationTimeForNextFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Widget.5
      bool success = true;
      ::blink::mojom::blink::RecordContentToVisibleTimeRequestPtr p_visible_time_request{};
      Widget_RequestSuccessfulPresentationTimeForNextFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVisibleTimeRequest(&p_visible_time_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Widget::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestSuccessfulPresentationTimeForNextFrame(        
        std::move(p_visible_time_request));
      return true;
    }
    case messages::Widget::kCancelSuccessfulPresentationTimeRequest: {
      DCHECK(message->is_serialized());
      internal::Widget_CancelSuccessfulPresentationTimeRequest_Params_Data* params =
          reinterpret_cast<internal::Widget_CancelSuccessfulPresentationTimeRequest_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Widget.6
      bool success = true;
      Widget_CancelSuccessfulPresentationTimeRequest_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Widget::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelSuccessfulPresentationTimeRequest(        );
      return true;
    }
    case messages::Widget::kSetupBrowserRenderInputRouterConnections: {
      DCHECK(message->is_serialized());
      internal::Widget_SetupBrowserRenderInputRouterConnections_Params_Data* params =
          reinterpret_cast<internal::Widget_SetupBrowserRenderInputRouterConnections_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Widget.7
      bool success = true;
      ::mojo::PendingReceiver<RenderInputRouterClient> p_browser_client{};
      Widget_SetupBrowserRenderInputRouterConnections_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_browser_client =
            input_data_view.TakeBrowserClient<decltype(p_browser_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Widget::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetupBrowserRenderInputRouterConnections(        
        std::move(p_browser_client));
      return true;
    }
  }
  return false;
}

// static
bool WidgetStubDispatch::AcceptWithResponder(
    Widget* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Widget>(message->header()->name)) {
    case messages::Widget::kForceRedraw: {
      internal::Widget_ForceRedraw_Params_Data* params =
          reinterpret_cast<
              internal::Widget_ForceRedraw_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Widget.0
      bool success = true;
      Widget_ForceRedraw_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Widget::Name_, 0, false);
        return false;
      }
      auto callback =
          Widget_ForceRedraw_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForceRedraw(std::move(callback));
      return true;
    }
    case messages::Widget::kUpdateVisualProperties: {
      break;
    }
    case messages::Widget::kUpdateScreenRects: {
      internal::Widget_UpdateScreenRects_Params_Data* params =
          reinterpret_cast<
              internal::Widget_UpdateScreenRects_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Widget.2
      bool success = true;
      ::gfx::Rect p_widget_screen_rect{};
      ::gfx::Rect p_window_screen_rect{};
      Widget_UpdateScreenRects_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWidgetScreenRect(&p_widget_screen_rect))
        success = false;
      if (success && !input_data_view.ReadWindowScreenRect(&p_window_screen_rect))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Widget::Name_, 2, false);
        return false;
      }
      auto callback =
          Widget_UpdateScreenRects_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateScreenRects(        
        std::move(p_widget_screen_rect), 
        std::move(p_window_screen_rect), std::move(callback));
      return true;
    }
    case messages::Widget::kWasHidden: {
      break;
    }
    case messages::Widget::kWasShown: {
      break;
    }
    case messages::Widget::kRequestSuccessfulPresentationTimeForNextFrame: {
      break;
    }
    case messages::Widget::kCancelSuccessfulPresentationTimeRequest: {
      break;
    }
    case messages::Widget::kSetupBrowserRenderInputRouterConnections: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWidgetValidationInfo[] = {
    { &internal::Widget_ForceRedraw_Params_Data::Validate,
     &internal::Widget_ForceRedraw_ResponseParams_Data::Validate},
    { &internal::Widget_UpdateVisualProperties_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Widget_UpdateScreenRects_Params_Data::Validate,
     &internal::Widget_UpdateScreenRects_ResponseParams_Data::Validate},
    { &internal::Widget_WasHidden_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Widget_WasShown_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Widget_RequestSuccessfulPresentationTimeForNextFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Widget_CancelSuccessfulPresentationTimeRequest_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Widget_SetupBrowserRenderInputRouterConnections_Params_Data::Validate,
     nullptr /* no response */},
};

bool WidgetRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::Widget::Name_,
    kWidgetValidationInfo);
}

bool WidgetResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::Widget::Name_,
    kWidgetValidationInfo);
}
// The declaration includes the definition on other builds.

RenderInputRouterClient::IPCStableHashFunction RenderInputRouterClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RenderInputRouterClient>(message.name())) {
    case messages::RenderInputRouterClient::kGetWidgetInputHandler: {
      return &RenderInputRouterClient::GetWidgetInputHandler_Sym::IPCStableHash;
    }
    case messages::RenderInputRouterClient::kShowContextMenu: {
      return &RenderInputRouterClient::ShowContextMenu_Sym::IPCStableHash;
    }
    case messages::RenderInputRouterClient::kBindInputTargetClient: {
      return &RenderInputRouterClient::BindInputTargetClient_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RenderInputRouterClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RenderInputRouterClient>(message.name())) {
      case messages::RenderInputRouterClient::kGetWidgetInputHandler:
            return "Receive blink::mojom::RenderInputRouterClient::GetWidgetInputHandler";
      case messages::RenderInputRouterClient::kShowContextMenu:
            return "Receive blink::mojom::RenderInputRouterClient::ShowContextMenu";
      case messages::RenderInputRouterClient::kBindInputTargetClient:
            return "Receive blink::mojom::RenderInputRouterClient::BindInputTargetClient";
    }
  } else {
    switch (static_cast<messages::RenderInputRouterClient>(message.name())) {
      case messages::RenderInputRouterClient::kGetWidgetInputHandler:
            return "Receive reply blink::mojom::RenderInputRouterClient::GetWidgetInputHandler";
      case messages::RenderInputRouterClient::kShowContextMenu:
            return "Receive reply blink::mojom::RenderInputRouterClient::ShowContextMenu";
      case messages::RenderInputRouterClient::kBindInputTargetClient:
            return "Receive reply blink::mojom::RenderInputRouterClient::BindInputTargetClient";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RenderInputRouterClient::GetWidgetInputHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x59f3419b;  // IPCStableHash for blink::mojom::RenderInputRouterClient::GetWidgetInputHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderInputRouterClient::ShowContextMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb2a33d6b;  // IPCStableHash for blink::mojom::RenderInputRouterClient::ShowContextMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderInputRouterClient::BindInputTargetClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x95ae847b;  // IPCStableHash for blink::mojom::RenderInputRouterClient::BindInputTargetClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RenderInputRouterClientProxy::RenderInputRouterClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RenderInputRouterClientProxy::GetWidgetInputHandler(
    ::mojo::PendingReceiver<::blink::mojom::blink::WidgetInputHandler> in_request, ::mojo::PendingRemote<::blink::mojom::blink::WidgetInputHandlerHost> in_host, bool in_from_viz) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RenderInputRouterClient::GetWidgetInputHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::WidgetInputHandler>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::WidgetInputHandlerHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("from_viz"), in_from_viz,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderInputRouterClient::kGetWidgetInputHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RenderInputRouterClient_GetWidgetInputHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::WidgetInputHandlerInterfaceBase>>(
    in_request,
    &params->request,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->request)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid request in RenderInputRouterClient.GetWidgetInputHandler request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::WidgetInputHandlerHostInterfaceBase>>(
    in_host,
    &params->host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid host in RenderInputRouterClient.GetWidgetInputHandler request");

  params->from_viz = in_from_viz;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderInputRouterClient::Name_);
  message.set_method_name("GetWidgetInputHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderInputRouterClientProxy::ShowContextMenu(
    ::ui::mojom::blink::MenuSourceType in_source_type, const ::gfx::Point& in_location) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RenderInputRouterClient::ShowContextMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_type"), in_source_type,
                        "<value of type ::ui::mojom::blink::MenuSourceType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("location"), in_location,
                        "<value of type const ::gfx::Point&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderInputRouterClient::kShowContextMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RenderInputRouterClient_ShowContextMenu_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::ui::mojom::MenuSourceType>(
    in_source_type,
    &params->source_type);
  mojo::internal::MessageFragment<
      typename decltype(params->location)::BaseType> location_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_location,
    location_fragment);

  params->location.Set(
      location_fragment.is_null() ? nullptr : location_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->location.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null location in RenderInputRouterClient.ShowContextMenu request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderInputRouterClient::Name_);
  message.set_method_name("ShowContextMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderInputRouterClientProxy::BindInputTargetClient(
    ::mojo::PendingReceiver<::viz::mojom::blink::InputTargetClient> in_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RenderInputRouterClient::BindInputTargetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type ::mojo::PendingReceiver<::viz::mojom::blink::InputTargetClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderInputRouterClient::kBindInputTargetClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RenderInputRouterClient_BindInputTargetClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::InputTargetClientInterfaceBase>>(
    in_host,
    &params->host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid host in RenderInputRouterClient.BindInputTargetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderInputRouterClient::Name_);
  message.set_method_name("BindInputTargetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RenderInputRouterClientStubDispatch::Accept(
    RenderInputRouterClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RenderInputRouterClient>(message->header()->name)) {
    case messages::RenderInputRouterClient::kGetWidgetInputHandler: {
      DCHECK(message->is_serialized());
      internal::RenderInputRouterClient_GetWidgetInputHandler_Params_Data* params =
          reinterpret_cast<internal::RenderInputRouterClient_GetWidgetInputHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderInputRouterClient.0
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::blink::WidgetInputHandler> p_request{};
      ::mojo::PendingRemote<::blink::mojom::blink::WidgetInputHandlerHost> p_host{};
      bool p_from_viz{};
      RenderInputRouterClient_GetWidgetInputHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_request =
            input_data_view.TakeRequest<decltype(p_request)>();
      }
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (success)
        p_from_viz = input_data_view.from_viz();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderInputRouterClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetWidgetInputHandler(        
        std::move(p_request), 
        std::move(p_host), 
        std::move(p_from_viz));
      return true;
    }
    case messages::RenderInputRouterClient::kShowContextMenu: {
      DCHECK(message->is_serialized());
      internal::RenderInputRouterClient_ShowContextMenu_Params_Data* params =
          reinterpret_cast<internal::RenderInputRouterClient_ShowContextMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderInputRouterClient.1
      bool success = true;
      ::ui::mojom::blink::MenuSourceType p_source_type{};
      ::gfx::Point p_location{};
      RenderInputRouterClient_ShowContextMenu_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSourceType(&p_source_type))
        success = false;
      if (success && !input_data_view.ReadLocation(&p_location))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderInputRouterClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowContextMenu(        
        std::move(p_source_type), 
        std::move(p_location));
      return true;
    }
    case messages::RenderInputRouterClient::kBindInputTargetClient: {
      DCHECK(message->is_serialized());
      internal::RenderInputRouterClient_BindInputTargetClient_Params_Data* params =
          reinterpret_cast<internal::RenderInputRouterClient_BindInputTargetClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderInputRouterClient.2
      bool success = true;
      ::mojo::PendingReceiver<::viz::mojom::blink::InputTargetClient> p_host{};
      RenderInputRouterClient_BindInputTargetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderInputRouterClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindInputTargetClient(        
        std::move(p_host));
      return true;
    }
  }
  return false;
}

// static
bool RenderInputRouterClientStubDispatch::AcceptWithResponder(
    RenderInputRouterClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RenderInputRouterClient>(message->header()->name)) {
    case messages::RenderInputRouterClient::kGetWidgetInputHandler: {
      break;
    }
    case messages::RenderInputRouterClient::kShowContextMenu: {
      break;
    }
    case messages::RenderInputRouterClient::kBindInputTargetClient: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRenderInputRouterClientValidationInfo[] = {
    { &internal::RenderInputRouterClient_GetWidgetInputHandler_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderInputRouterClient_ShowContextMenu_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderInputRouterClient_BindInputTargetClient_Params_Data::Validate,
     nullptr /* no response */},
};

bool RenderInputRouterClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::RenderInputRouterClient::Name_,
    kRenderInputRouterClientValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void WidgetCompositorInterceptorForTesting::VisualStateRequest(VisualStateRequestCallback callback) {
  GetForwardingInterface()->VisualStateRequest(std::move(callback));
}
WidgetCompositorAsyncWaiter::WidgetCompositorAsyncWaiter(
    WidgetCompositor* proxy) : proxy_(proxy) {}

WidgetCompositorAsyncWaiter::~WidgetCompositorAsyncWaiter() = default;


void WidgetCompositorAsyncWaiter::VisualStateRequest(
    ) {
  base::RunLoop loop;
  proxy_->VisualStateRequest(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void WidgetHostInterceptorForTesting::SetCursor(const ::ui::Cursor& cursor) {
  GetForwardingInterface()->SetCursor(
    std::move(cursor)
    );
}
void WidgetHostInterceptorForTesting::UpdateTooltipUnderCursor(const ::blink::String& tooltip_text, ::base::i18n::TextDirection text_direction_hint) {
  GetForwardingInterface()->UpdateTooltipUnderCursor(
    std::move(tooltip_text)
    , 
    std::move(text_direction_hint)
    );
}
void WidgetHostInterceptorForTesting::UpdateTooltipFromKeyboard(const ::blink::String& tooltip_text, ::base::i18n::TextDirection text_direction_hint, const ::gfx::Rect& bounds) {
  GetForwardingInterface()->UpdateTooltipFromKeyboard(
    std::move(tooltip_text)
    , 
    std::move(text_direction_hint)
    , 
    std::move(bounds)
    );
}
void WidgetHostInterceptorForTesting::ClearKeyboardTriggeredTooltip() {
  GetForwardingInterface()->ClearKeyboardTriggeredTooltip();
}
void WidgetHostInterceptorForTesting::TextInputStateChanged(::ui::mojom::blink::TextInputStatePtr state) {
  GetForwardingInterface()->TextInputStateChanged(
    std::move(state)
    );
}
void WidgetHostInterceptorForTesting::SelectionBoundsChanged(const ::gfx::Rect& anchor_rect, ::base::i18n::TextDirection anchor_dir, const ::gfx::Rect& focus_rect, ::base::i18n::TextDirection focus_dir, const ::gfx::Rect& bounding_box_rect, bool is_anchor_first) {
  GetForwardingInterface()->SelectionBoundsChanged(
    std::move(anchor_rect)
    , 
    std::move(anchor_dir)
    , 
    std::move(focus_rect)
    , 
    std::move(focus_dir)
    , 
    std::move(bounding_box_rect)
    , 
    std::move(is_anchor_first)
    );
}
void WidgetHostInterceptorForTesting::CreateFrameSink(::mojo::PendingReceiver<::viz::mojom::blink::CompositorFrameSink> compositor_frame_sink_receiver, ::mojo::PendingRemote<::viz::mojom::blink::CompositorFrameSinkClient> compositor_frame_sink_client, ::mojo::PendingRemote<RenderInputRouterClient> render_input_router_client) {
  GetForwardingInterface()->CreateFrameSink(
    std::move(compositor_frame_sink_receiver)
    , 
    std::move(compositor_frame_sink_client)
    , 
    std::move(render_input_router_client)
    );
}
void WidgetHostInterceptorForTesting::RegisterRenderFrameMetadataObserver(::mojo::PendingReceiver<::cc::mojom::blink::RenderFrameMetadataObserverClient> render_frame_metadata_observer_client_receiver, ::mojo::PendingRemote<::cc::mojom::blink::RenderFrameMetadataObserver> render_frame_metadata_observer) {
  GetForwardingInterface()->RegisterRenderFrameMetadataObserver(
    std::move(render_frame_metadata_observer_client_receiver)
    , 
    std::move(render_frame_metadata_observer)
    );
}
WidgetHostAsyncWaiter::WidgetHostAsyncWaiter(
    WidgetHost* proxy) : proxy_(proxy) {}

WidgetHostAsyncWaiter::~WidgetHostAsyncWaiter() = default;





void WidgetInterceptorForTesting::ForceRedraw(ForceRedrawCallback callback) {
  GetForwardingInterface()->ForceRedraw(std::move(callback));
}
void WidgetInterceptorForTesting::UpdateVisualProperties(const ::blink::VisualProperties& visual_properties) {
  GetForwardingInterface()->UpdateVisualProperties(
    std::move(visual_properties)
    );
}
void WidgetInterceptorForTesting::UpdateScreenRects(const ::gfx::Rect& widget_screen_rect, const ::gfx::Rect& window_screen_rect, UpdateScreenRectsCallback callback) {
  GetForwardingInterface()->UpdateScreenRects(
    std::move(widget_screen_rect)
    , 
    std::move(window_screen_rect)
    , std::move(callback));
}
void WidgetInterceptorForTesting::WasHidden() {
  GetForwardingInterface()->WasHidden();
}
void WidgetInterceptorForTesting::WasShown(bool was_evicted, ::blink::mojom::blink::RecordContentToVisibleTimeRequestPtr record_tab_switch_time_request) {
  GetForwardingInterface()->WasShown(
    std::move(was_evicted)
    , 
    std::move(record_tab_switch_time_request)
    );
}
void WidgetInterceptorForTesting::RequestSuccessfulPresentationTimeForNextFrame(::blink::mojom::blink::RecordContentToVisibleTimeRequestPtr visible_time_request) {
  GetForwardingInterface()->RequestSuccessfulPresentationTimeForNextFrame(
    std::move(visible_time_request)
    );
}
void WidgetInterceptorForTesting::CancelSuccessfulPresentationTimeRequest() {
  GetForwardingInterface()->CancelSuccessfulPresentationTimeRequest();
}
void WidgetInterceptorForTesting::SetupBrowserRenderInputRouterConnections(::mojo::PendingReceiver<RenderInputRouterClient> browser_client) {
  GetForwardingInterface()->SetupBrowserRenderInputRouterConnections(
    std::move(browser_client)
    );
}
WidgetAsyncWaiter::WidgetAsyncWaiter(
    Widget* proxy) : proxy_(proxy) {}

WidgetAsyncWaiter::~WidgetAsyncWaiter() = default;


void WidgetAsyncWaiter::ForceRedraw(
    ) {
  base::RunLoop loop;
  proxy_->ForceRedraw(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void WidgetAsyncWaiter::UpdateScreenRects(
    const ::gfx::Rect& widget_screen_rect, const ::gfx::Rect& window_screen_rect) {
  base::RunLoop loop;
  proxy_->UpdateScreenRects(
      std::move(widget_screen_rect),
      std::move(window_screen_rect),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void RenderInputRouterClientInterceptorForTesting::GetWidgetInputHandler(::mojo::PendingReceiver<::blink::mojom::blink::WidgetInputHandler> request, ::mojo::PendingRemote<::blink::mojom::blink::WidgetInputHandlerHost> host, bool from_viz) {
  GetForwardingInterface()->GetWidgetInputHandler(
    std::move(request)
    , 
    std::move(host)
    , 
    std::move(from_viz)
    );
}
void RenderInputRouterClientInterceptorForTesting::ShowContextMenu(::ui::mojom::blink::MenuSourceType source_type, const ::gfx::Point& location) {
  GetForwardingInterface()->ShowContextMenu(
    std::move(source_type)
    , 
    std::move(location)
    );
}
void RenderInputRouterClientInterceptorForTesting::BindInputTargetClient(::mojo::PendingReceiver<::viz::mojom::blink::InputTargetClient> host) {
  GetForwardingInterface()->BindInputTargetClient(
    std::move(host)
    );
}
RenderInputRouterClientAsyncWaiter::RenderInputRouterClientAsyncWaiter(
    RenderInputRouterClient* proxy) : proxy_(proxy) {}

RenderInputRouterClientAsyncWaiter::~RenderInputRouterClientAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif